/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class HorizontalPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_hor.png");

    public HorizontalPotionRenderer(Minecraft mc) {
        super(mc);
    }

    private int getX(int width, int effCount) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - 18 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 18 - (effCount - 1) * (36 + this.potGap) - this.potX;
                    break;
                }
                result = (int)((float)(width / 2 - 18) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 18.0f) - (float)this.potX);
                break;
            }
            case RIGHT: {
                result = width - this.potX - (effCount - 1) * (this.potGap + 36);
            }
        }
        return result;
    }

    private int getY(int height) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                result = height / 2 - 18 - this.potY;
                break;
            }
            case BOTTOM: {
                result = height - this.potY;
            }
        }
        return result;
    }

    @Override
    public void render(PoseStack mat, int width, int height) {
        int x = 0;
        int effCount = this.mc.f_91074_.m_21220_().size();
        if (effCount == 0) {
            return;
        }
        MobEffectTextureManager potionspriteuploader = this.mc.m_91306_();
        mat.m_85836_();
        mat.m_85837_(0.0, 0.0, -255.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        int xPos = this.getX(width, effCount);
        int yPos = this.getY(height);
        for (MobEffectInstance effect : this.mc.f_91074_.m_21220_()) {
            MobEffect pot = effect.m_19544_();
            mat.m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
            RenderSystem.m_69478_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.PBG);
            HorizontalPotionRenderer.m_93133_((PoseStack)mat, (int)(xPos + x), (int)yPos, (float)36.0f, (float)38.0f, (int)36, (int)38, (int)36, (int)38);
            RenderSystem.m_69461_();
            mat.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite textureatlassprite = potionspriteuploader.m_118732_(pot);
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
            HorizontalPotionRenderer.m_93200_((PoseStack)mat, (int)(xPos + x + 9), (int)(yPos + 3), (int)this.m_93252_(), (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
            ResourceLocation lev = effect.m_19564_() < 9 && effect.m_19564_() >= 0 ? new ResourceLocation("inventoryhud", "textures/gui/l_" + effect.m_19564_() + ".png") : new ResourceLocation("inventoryhud", "textures/gui/l_inf.png");
            RenderSystem.m_157456_((int)0, (ResourceLocation)lev);
            HorizontalPotionRenderer.m_93133_((PoseStack)mat, (int)(xPos + x + 21), (int)yPos, (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
            Object time = "";
            int dur = effect.m_19557_() / 20;
            if (dur > 1600) {
                time = " **:**";
            } else {
                String mins = "" + dur / 60;
                String secs = "" + dur % 60;
                if (dur / 60 < 10) {
                    mins = "0" + mins;
                }
                if (dur % 60 < 10) {
                    secs = "0" + secs;
                }
                time = dur > 10 ? mins + ":" + secs : ChatFormatting.RED + mins + ChatFormatting.WHITE + ":" + ChatFormatting.RED + secs;
            }
            this.fontRenderer.m_92750_(mat, (String)time, (float)(xPos + x + 5), (float)(yPos + 25), 0xFFFFFF);
            x += 36 + this.potGap;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        mat.m_85849_();
    }
}

