/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.capability;

import beyond_earth_giselle_addon.common.capability.ChargeMode;
import beyond_earth_giselle_addon.common.capability.IChargeMode;
import beyond_earth_giselle_addon.common.capability.IChargeModeHandler;
import beyond_earth_giselle_addon.common.capability.IOxygenCharger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;

public class CapabilityChargeModeHandler {
    public static Capability<IChargeModeHandler> CHARGE_MODE_HANDLER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChargeModeHandler>(){});

    @Nonnull
    public static IChargeMode find(@Nullable List<IChargeMode> availableModes, @Nullable ResourceLocation name) {
        if (availableModes == null || name == null) {
            return ChargeMode.NONE;
        }
        for (IChargeMode mode : availableModes) {
            if (!mode.getName().equals((Object)name)) continue;
            return mode;
        }
        return ChargeMode.NONE;
    }

    public static Tag writeNBT(@Nullable IChargeMode mode) {
        ResourceLocation name = (mode != null ? mode : ChargeMode.NONE).getName();
        return StringTag.m_129297_((String)name.toString());
    }

    @Nonnull
    public static IChargeMode readNBT(@Nullable IChargeModeHandler instance, @Nullable Tag tag) {
        if (instance == null) {
            return ChargeMode.NONE;
        }
        return CapabilityChargeModeHandler.readNBT(instance.getAvailableChargeModes(), tag);
    }

    @Nonnull
    public static IChargeMode readNBT(@Nullable List<IChargeMode> availableModes, @Nullable Tag tag) {
        if (tag == null) {
            return ChargeMode.NONE;
        }
        ResourceLocation name = ResourceLocation.m_135820_((String)tag.m_7916_());
        return CapabilityChargeModeHandler.find(availableModes, name);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(IOxygenCharger.class);
    }

    private CapabilityChargeModeHandler() {
    }
}

