/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jei;

import beyond_earth_giselle_addon.client.gui.AdvancedCompressorScreen;
import beyond_earth_giselle_addon.client.gui.ElectricBlastFurnaceScreen;
import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.block.entity.AdvancedCompressorBlockEntity;
import beyond_earth_giselle_addon.common.compat.jei.AddonJeiCompressorModeHelper;
import beyond_earth_giselle_addon.common.compat.jei.AdvancedCompressorRegistration;
import beyond_earth_giselle_addon.common.compat.jei.IIS2ISRegistration;
import beyond_earth_giselle_addon.common.compat.jei.IS2ISRegistration;
import beyond_earth_giselle_addon.common.compat.jei.RecipeCategory;
import beyond_earth_giselle_addon.common.compat.jei.RecipeCategoryFuelLoader;
import beyond_earth_giselle_addon.common.compat.jei.RecipeCategoryItemStackToItemStack;
import beyond_earth_giselle_addon.common.config.AddonConfigs;
import beyond_earth_giselle_addon.common.inventory.AdvancedCompressorContainerMenu;
import beyond_earth_giselle_addon.common.inventory.ElectricBlastFurnaceContainerMenu;
import beyond_earth_giselle_addon.common.item.crafting.ExtrudingRecipe;
import beyond_earth_giselle_addon.common.item.crafting.RollingRecipe;
import beyond_earth_giselle_addon.common.registries.AddonBlocks;
import beyond_earth_giselle_addon.common.registries.AddonRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.mrscauthd.beyond_earth.crafting.CompressingRecipe;
import net.mrscauthd.beyond_earth.crafting.ItemStackToItemStackRecipeType;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;
import net.mrscauthd.beyond_earth.jei.JeiPlugin;
import net.mrscauthd.beyond_earth.registries.TagsRegistry;

@JeiPlugin
public class AddonJeiPlugin
implements IModPlugin {
    public static final String JEI_CATEGORY = "jei.category";
    public static final String JEI_INFO = "jei.info";
    public static final String JEI_TOOLTIP = "jei.tooltip";
    private static AddonJeiPlugin instance;
    private final List<IIS2ISRegistration<?, ?>> is2isRegistrations;
    private IIS2ISRegistration<ElectricBlastFurnaceScreen, ElectricBlastFurnaceContainerMenu> electricBlastFurnace;
    private IIS2ISRegistration<AdvancedCompressorScreen, AdvancedCompressorContainerMenu> advancedCompressor;
    private final List<RecipeCategory<?>> categories;
    private RecipeCategory<RollingRecipe> rollingCategory;
    private RecipeCategory<ExtrudingRecipe> extrudingCategory;
    private RecipeCategoryFuelLoader fuelLoaderCategory;
    private IDrawable fluidOverlay;

    public static AddonJeiPlugin instance() {
        return instance;
    }

    public static final ResourceLocation createUid(ResourceLocation key) {
        return new ResourceLocation(key.m_135827_(), "jei.category." + key.m_135815_());
    }

    public static final Component getCategoryTitle(ResourceLocation key) {
        return new TranslatableComponent("jei.category." + key.m_135827_() + "." + key.m_135815_());
    }

    public AddonJeiPlugin() {
        instance = this;
        this.categories = new ArrayList();
        this.is2isRegistrations = new ArrayList();
    }

    public ResourceLocation getPluginUid() {
        return BeyondEarthAddon.rl("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.categories.clear();
        this.is2isRegistrations.clear();
        this.rollingCategory = new RecipeCategoryItemStackToItemStack<ItemStackToItemStackRecipeType<RollingRecipe>, RollingRecipe>(RollingRecipe.class, AddonRecipes.ROLLING);
        this.categories.add(this.rollingCategory);
        this.extrudingCategory = new RecipeCategoryItemStackToItemStack<ItemStackToItemStackRecipeType<ExtrudingRecipe>, ExtrudingRecipe>(ExtrudingRecipe.class, AddonRecipes.EXTRUDING);
        this.categories.add(this.extrudingCategory);
        this.fuelLoaderCategory = new RecipeCategoryFuelLoader(Fluid.class);
        this.categories.add(this.fuelLoaderCategory);
        AddonJeiCompressorModeHelper compressorModeHelper = AddonJeiCompressorModeHelper.INSTANCE;
        compressorModeHelper.register(AdvancedCompressorBlockEntity.CompressorMode.COMPRESSING, JeiPlugin.CompressorJeiCategory.Uid);
        compressorModeHelper.register(AdvancedCompressorBlockEntity.CompressorMode.ROLLING, this.getRollingCategory().getRecipeType().getUid());
        compressorModeHelper.register(AdvancedCompressorBlockEntity.CompressorMode.EXTRUDING, this.getExtrudingCategory().getRecipeType().getUid());
        this.electricBlastFurnace = new IS2ISRegistration(ElectricBlastFurnaceScreen.class, ElectricBlastFurnaceContainerMenu.class);
        this.is2isRegistrations.add(this.electricBlastFurnace);
        this.electricBlastFurnace.getRecipeTypes().add(RecipeTypes.BLASTING);
        this.electricBlastFurnace.getItemstacks().add(new ItemStack((ItemLike)AddonBlocks.ELECTRIC_BLAST_FURNACE.get()));
        this.advancedCompressor = new AdvancedCompressorRegistration(AdvancedCompressorScreen.class, AdvancedCompressorContainerMenu.class);
        this.is2isRegistrations.add(this.advancedCompressor);
        this.advancedCompressor.getRecipeTypes().add(new RecipeType(JeiPlugin.CompressorJeiCategory.Uid, CompressingRecipe.class));
        this.advancedCompressor.getRecipeTypes().add(this.getRollingCategory().getRecipeType());
        this.advancedCompressor.getRecipeTypes().add(this.getExtrudingCategory().getRecipeType());
        this.advancedCompressor.getItemstacks().add(new ItemStack((ItemLike)AddonBlocks.ADVANCED_COMPRESSOR.get()));
        this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
        for (RecipeCategory<?> recipeCategory : this.getCategories()) {
            recipeCategory.createGui(guiHelper);
            registration.addRecipeCategories(new IRecipeCategory[]{recipeCategory});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        for (RecipeCategory<?> recipeCategory : this.getCategories()) {
            recipeCategory.addRecipeTransferHandler(registration);
        }
        for (IIS2ISRegistration iIS2ISRegistration : this.getItemStackToItemStackRegistrations()) {
            iIS2ISRegistration.addRecipeTransferHandler(registration);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (RecipeCategory<?> recipeCategory : this.getCategories()) {
            recipeCategory.registerRecipeCatalysts(registration);
        }
        for (IIS2ISRegistration iIS2ISRegistration : this.getItemStackToItemStackRegistrations()) {
            iIS2ISRegistration.registerRecipeCatalysts(registration);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        for (RecipeCategory<?> recipeCategory : this.getCategories()) {
            recipeCategory.registerGuiHandlers(registration);
        }
        for (IIS2ISRegistration iIS2ISRegistration : this.getItemStackToItemStackRegistrations()) {
            iIS2ISRegistration.registerGuiHandlers(registration);
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (RecipeCategory<?> recipeCategory : this.getCategories()) {
            recipeCategory.registerRecipes(registration);
        }
        this.addIngredientInfo(registration, (ItemLike)AddonBlocks.FUEL_LOADER.get(), AddonConfigs.Common.machines.fuelLoader_range.get(), TagsRegistry.FLUID_VEHICLE_FUEL_TAG.f_203868_());
        this.addIngredientInfo(registration, (ItemLike)AddonBlocks.GRAVITY_NORMALIZER.get(), new Object[0]);
    }

    public void addIngredientInfo(IRecipeRegistration registration, ItemLike itemLike, Object ... objects) {
        registration.addIngredientInfo((Object)new ItemStack(itemLike), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent(BeyondEarthAddon.tl(JEI_INFO, itemLike.m_5456_().getRegistryName()), objects)});
    }

    public List<IIS2ISRegistration<?, ?>> getItemStackToItemStackRegistrations() {
        return this.is2isRegistrations;
    }

    public List<RecipeCategory<?>> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public RecipeCategory<RollingRecipe> getRollingCategory() {
        return this.rollingCategory;
    }

    public RecipeCategory<ExtrudingRecipe> getExtrudingCategory() {
        return this.extrudingCategory;
    }

    public RecipeCategoryFuelLoader getFuelLoaderCategory() {
        return this.fuelLoaderCategory;
    }

    public IDrawable getFluidOverlay() {
        return this.fluidOverlay;
    }
}

