/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jer;

import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.compat.jei.AddonJeiPlugin;
import beyond_earth_giselle_addon.common.compat.jer.AlienTradeList;
import beyond_earth_giselle_addon.common.compat.jer.AlienWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.jei.BlankJEIRecipeCategory;
import jeresources.reference.Resources;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AlienCategory
extends BlankJEIRecipeCategory<AlienWrapper> {
    public static final ResourceLocation KEY = BeyondEarthAddon.rl("alien_trading");
    public static final ResourceLocation UID = AddonJeiPlugin.createUid(KEY);
    public static final RecipeType<AlienWrapper> TYPE = new RecipeType(UID, AlienWrapper.class);
    protected static final int X_FIRST_ITEM = 95;
    protected static final int X_ITEM_DISTANCE = 18;
    protected static final int X_ITEM_RESULT = 150;
    protected static final int Y_ITEM_DISTANCE = 22;

    public AlienCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(Resources.Gui.Jei.TABS, 0, 0, 16, 16));
    }

    public static RecipeType<AlienWrapper> getType() {
        return TYPE;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Component getTitle() {
        return AddonJeiPlugin.getCategoryTitle(KEY);
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.VILLAGER;
    }

    public Class<? extends AlienWrapper> getRecipeClass() {
        return AlienWrapper.class;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull AlienWrapper recipeWrapper, @NotNull IFocusGroup focuses) {
        if (recipeWrapper.hasPois()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 50, 19).addItemStacks(recipeWrapper.getPois());
        }
        IFocus focus = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).findFirst().orElse(null);
        List<Integer> possibleLevels = recipeWrapper.getPossibleLevels((IFocus<ItemStack>)focus);
        int y = 1 + 22 * (6 - possibleLevels.size()) / 2;
        for (int i = 0; i < possibleLevels.size(); ++i) {
            AlienTradeList tradeList = recipeWrapper.getTrades(possibleLevels.get(i)).getFocusedList((IFocus<ItemStack>)focus);
            builder.addSlot(RecipeIngredientRole.INPUT, 96, y + i * 22).addItemStacks(tradeList.getCostAs());
            builder.addSlot(RecipeIngredientRole.INPUT, 114, y + i * 22).addItemStacks(tradeList.getCostBs());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 151, y + i * 22).addItemStacks(tradeList.getResults());
        }
    }
}

