/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jer;

import beyond_earth_giselle_addon.common.compat.jer.AlienEntry;
import beyond_earth_giselle_addon.common.compat.jer.AlienTradeList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import jeresources.reference.Resources;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.mrscauthd.beyond_earth.entities.alien.AlienEntity;

public class AlienWrapper
implements IRecipeCategoryExtension {
    private final AlienEntry entry;
    private IFocus<ItemStack> focus;

    public AlienWrapper(AlienEntry entry) {
        this.entry = entry;
    }

    public AlienTradeList getTrades(int level) {
        return this.entry.getAlienTrade(level);
    }

    public int getMaxLevel() {
        return this.entry.getMaxLevel();
    }

    public List<Integer> getPossibleLevels(IFocus<ItemStack> focus) {
        return this.entry.getPossibleLevels(focus);
    }

    public void setFocus(IFocus<ItemStack> focus) {
        this.focus = focus;
    }

    public List<ItemStack> getPois() {
        return this.entry.getPois();
    }

    public boolean hasPois() {
        return this.entry.hasPois();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, PoseStack poseStack, double mouseX, double mouseY) {
        int i;
        RenderHelper.scissor((PoseStack)poseStack, (int)7, (int)43, (int)59, (int)79);
        AlienEntity alien = this.entry.getAlienEntity();
        RenderHelper.renderEntity((PoseStack)poseStack, (int)37, (int)118, (double)36.0, (double)(38.0 - mouseX), (double)(80.0 - mouseY), (LivingEntity)alien);
        RenderHelper.stopScissor();
        int y = 22 * (6 - this.getPossibleLevels(this.focus).size()) / 2;
        for (i = 0; i < this.getPossibleLevels(this.focus).size(); ++i) {
            RenderHelper.drawTexture((PoseStack)poseStack, (int)130, (int)(y + i * 22), (int)0, (int)120, (int)20, (int)20, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
            RenderHelper.drawTexture((PoseStack)poseStack, (int)95, (int)(y + i * 22), (int)22, (int)120, (int)18, (int)18, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
            RenderHelper.drawTexture((PoseStack)poseStack, (int)113, (int)(y + i * 22), (int)22, (int)120, (int)18, (int)18, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
            RenderHelper.drawTexture((PoseStack)poseStack, (int)150, (int)(y + i * 22), (int)22, (int)120, (int)18, (int)18, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
        }
        i = 0;
        for (int level : this.getPossibleLevels(this.focus)) {
            Font.normal.print(poseStack, "lv. " + (level + 1), 72, y + i++ * 22 + 6);
        }
        Font.normal.print(poseStack, TranslationHelper.translateAndFormat((String)this.entry.getDisplayName(), (Object[])new Object[0]), 5, 5);
        if (this.entry.hasPois()) {
            Font.normal.splitPrint(poseStack, TranslationHelper.translateAndFormat((String)"jer.villager.poi", (Object[])new Object[0]), 5, 18, 45);
            RenderHelper.drawTexture((PoseStack)poseStack, (int)49, (int)18, (int)22, (int)120, (int)18, (int)18, (ResourceLocation)Resources.Gui.Jei.VILLAGER.getResource());
        }
    }
}

