/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.mekanism.gear;

import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.capability.IOxygenCharger;
import beyond_earth_giselle_addon.common.capability.OxygenChargerUtils;
import beyond_earth_giselle_addon.common.config.AddonConfigs;
import java.util.Map;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;

public class ModuleSpaceBreathingUnit
implements ICustomModule<ModuleSpaceBreathingUnit> {
    public static final ResourceLocation ICON = BeyondEarthAddon.rl(MekanismUtils.ResourceType.GUI_HUD.getPrefix() + "space_breathing_unit.png");
    private int oxygenDuration = 0;
    private FloatingLong energyUsingProvide;
    private FloatingLong energyUsingProduce;

    public void init(IModule<ModuleSpaceBreathingUnit> module, ModuleConfigItemCreator configItemCreator) {
        super.init(module, configItemCreator);
        this.oxygenDuration = (Integer)AddonConfigs.Common.mekanism.moduleSpaceBreathing_oxygenDuration.get();
        this.energyUsingProvide = FloatingLong.create((long)((Integer)AddonConfigs.Common.mekanism.moduleSpaceBreathing_energyUsingProvide.get()).intValue());
        this.energyUsingProduce = FloatingLong.create((long)((Integer)AddonConfigs.Common.mekanism.moduleSpaceBreathing_energyUsingProduce.get()).intValue());
    }

    public int provideOxygen(IModule<ModuleSpaceBreathingUnit> module, LivingEntity entity) {
        if (this.useResources(module, entity)) {
            return this.getOxygenDuration();
        }
        return 0;
    }

    public void tickServer(IModule<ModuleSpaceBreathingUnit> module, Player player) {
        super.tickServer(module, player);
        this.produceOxygen(module, player);
    }

    private void produceOxygen(IModule<ModuleSpaceBreathingUnit> module, Player player) {
        long productionRate = this.getProduceRate(module, player);
        if (productionRate == 0L) {
            return;
        }
        FloatingLong energyUsing = this.getEnergyUsingProduce();
        long productionRateFirst = productionRate = Math.min(productionRate, (long)module.getContainerEnergy().divideToInt(energyUsing));
        ItemStack handStack = player.m_6844_(EquipmentSlot.MAINHAND);
        IGasHandler handCapability = (IGasHandler)handStack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).orElse(null);
        if (handCapability != null) {
            GasStack remain = (GasStack)handCapability.insertChemical((ChemicalStack)MekanismGases.OXYGEN.getStack(productionRate), Action.EXECUTE);
            productionRate = remain.getAmount();
        }
        long oxygenUsed = productionRateFirst - productionRate;
        FloatingLong multiply = energyUsing.multiply(oxygenUsed);
        if (!player.f_19853_.m_5776_()) {
            module.useEnergy((LivingEntity)player, multiply);
        }
        int airSupply = player.m_20146_();
        int airFill = (int)Math.min(productionRateFirst, (long)(player.m_6062_() - airSupply));
        player.m_20301_(airSupply + airFill);
    }

    public long getProduceRate(IModule<ModuleSpaceBreathingUnit> module, Player player) {
        float eyeHeight = player.m_20192_();
        Map fluidsIn = MekanismUtils.getFluidsIn((Player)player, bb -> {
            double centerX = (bb.f_82288_ + bb.f_82291_) / 2.0;
            double centerZ = (bb.f_82290_ + bb.f_82293_) / 2.0;
            return new AABB(centerX, Math.min(bb.f_82289_ + (double)eyeHeight - 0.27, bb.f_82292_), centerZ, centerX, Math.min(bb.f_82289_ + (double)eyeHeight - 0.14, bb.f_82292_), centerZ);
        });
        if (fluidsIn.entrySet().stream().anyMatch(entry -> MekanismTags.Fluids.WATER_LOOKUP.contains((IForgeRegistryEntry)((Fluid)entry.getKey())) && ((MekanismUtils.FluidInDetails)entry.getValue()).getMaxHeight() >= 0.11)) {
            return this.getMaxProduceRate(module);
        }
        if (player.m_20070_()) {
            return this.getMaxProduceRate(module) / 2L;
        }
        return 0L;
    }

    public boolean useResources(IModule<ModuleSpaceBreathingUnit> module, LivingEntity entity) {
        FloatingLong energyUsing;
        int oyxgenUsing = 1;
        IOxygenCharger oxygenCharnger = OxygenChargerUtils.firstExtractableOxygenCharger(entity, oyxgenUsing, module.getContainer());
        if (oxygenCharnger != null && module.canUseEnergy(entity, energyUsing = this.getEnergyUsingProvide())) {
            if (!entity.f_19853_.m_5776_()) {
                oxygenCharnger.getOxygenStorage().extractOxygen(oyxgenUsing, false);
                module.useEnergy(entity, energyUsing);
            }
            return true;
        }
        return false;
    }

    public void addHUDElements(IModule<ModuleSpaceBreathingUnit> module, Player player, Consumer<IHUDElement> hudElementAdder) {
        super.addHUDElements(module, player, hudElementAdder);
        if (!module.isEnabled()) {
            return;
        }
        IGaugeValue gauge = OxygenChargerUtils.getInventoryOxygenChargerStorage((LivingEntity)player);
        int capacity = gauge.getCapacity();
        double ratio = capacity > 0 ? StorageUtils.getRatio((long)gauge.getAmount(), (long)capacity) : 0.0;
        hudElementAdder.accept(MekanismAPI.getModuleHelper().hudElementPercent(ICON, ratio));
    }

    public long getMaxProduceRate(IModule<ModuleSpaceBreathingUnit> module) {
        return (long)Math.pow(2.0, module.getInstalledCount() - 1);
    }

    public int getOxygenDuration() {
        return this.oxygenDuration;
    }

    public FloatingLong getEnergyUsingProvide() {
        return this.energyUsingProvide;
    }

    public FloatingLong getEnergyUsingProduce() {
        return this.energyUsingProduce;
    }
}

