/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.content.gravity;

import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityEvent;
import net.mrscauthd.beyond_earth.events.Gravity;

public class GravityNormalizeUtils {
    public static final String NBT_KEY = BeyondEarthAddon.rl("gravity_normalizing").toString();
    public static final String NBT_NORMALIZING_KEY = "normalizing";

    public static void tryCancelGravity(EntityEvent e) {
        if (e.isCanceled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (GravityNormalizeUtils.isNormalizing(entity)) {
            e.setCanceled(true);
            GravityNormalizeUtils.setNormalizing(entity, false);
        }
    }

    public static void setNormalizing(Entity entity, boolean normalzing) {
        CompoundTag compound = NBTUtils.getOrCreateTag(entity.getPersistentData(), NBT_KEY);
        compound.m_128379_(NBT_NORMALIZING_KEY, normalzing);
    }

    public static boolean isNormalizing(Entity entity) {
        return NBTUtils.getTag(entity.getPersistentData(), NBT_KEY).m_128471_(NBT_NORMALIZING_KEY);
    }

    public static void resetNormalizingWithCheckType(Gravity.GravityType type, LivingEntity entity) {
        if (Gravity.checkType((Gravity.GravityType)type, (LivingEntity)entity)) {
            GravityNormalizeUtils.setNormalizing((Entity)entity, false);
        }
    }

    private GravityNormalizeUtils() {
    }
}

