/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.registries;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class DeferredRegisterWrapper<T extends IForgeRegistryEntry<T>> {
    private final String modid;
    private final DeferredRegister<T> impl;
    private final Set<T> objects;
    private final Set<T> readonlyObjects;

    protected DeferredRegisterWrapper(String modid, DeferredRegister<T> impl) {
        this.modid = modid;
        this.impl = impl;
        this.objects = new HashSet<T>();
        this.readonlyObjects = Collections.unmodifiableSet(this.objects);
    }

    protected DeferredRegisterWrapper(String modid, IForgeRegistry<T> reg) {
        this(modid, DeferredRegister.create(reg, (String)modid));
    }

    public static <T extends IForgeRegistryEntry<T>> DeferredRegisterWrapper<T> create(String modid, IForgeRegistry<T> reg) {
        return new DeferredRegisterWrapper<T>(modid, reg);
    }

    public void register(IEventBus bus) {
        this.impl.register(bus);
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        return this.impl.register(name, () -> {
            IForgeRegistryEntry object = (IForgeRegistryEntry)sup.get();
            this.objects.add(object);
            return object;
        });
    }

    public String getModid() {
        return this.modid;
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.impl.getEntries();
    }

    public Collection<T> getObjects() {
        return this.readonlyObjects;
    }
}

