/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.function.Consumer;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class GameProfileUtils {
    public static final String WHITELIST_HOST = "textures.minecraft.net";

    public static String toWhitelistUrl(String hash) {
        return "http://textures.minecraft.net/texture/" + hash;
    }

    public static void fillTextures(GameProfile gameProfile, String input, Consumer<GameProfile> callback) {
        try {
            URL url = new URL(input);
            if (url.getHost().equalsIgnoreCase(WHITELIST_HOST)) {
                GameProfileUtils.fillTexturesFromUrl(gameProfile, input);
            }
            callback.accept(gameProfile);
        }
        catch (MalformedURLException e) {
            try {
                String json = new String(Base64.getDecoder().decode(input));
                new Gson().fromJson(json, JsonObject.class);
                GameProfileUtils.fillTexturesFromBase64(gameProfile, input);
                callback.accept(gameProfile);
            }
            catch (Exception e2) {
                SkullBlockEntity.m_155738_((GameProfile)gameProfile, fromNickname -> {
                    if (fromNickname.getProperties().size() > 0) {
                        callback.accept((GameProfile)fromNickname);
                    } else {
                        GameProfileUtils.fillTexturesFromUrl(gameProfile, GameProfileUtils.toWhitelistUrl(input));
                        callback.accept(gameProfile);
                    }
                });
            }
        }
    }

    public static void fillTexturesFromUrl(GameProfile gameProfile, String url) {
        String str = "{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}";
        String base64 = Base64.getEncoder().encodeToString(str.getBytes());
        GameProfileUtils.fillTexturesFromBase64(gameProfile, base64);
    }

    public static void fillTexturesFromBase64(GameProfile gameProfile, String base64) {
        Property property = new Property("textures", base64);
        gameProfile.getProperties().put((Object)"textures", (Object)property);
    }

    private GameProfileUtils() {
    }
}

