/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModLogger;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.TranslationUtils;
import com.gitlab.cdagaming.craftpresence.utils.updater.ModUpdaterUtils;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.SharedConstants;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;

public class ModUtils {
    public static final String NAME;
    public static final String VERSION_ID;
    public static final String VERSION_TYPE;
    public static final String VERSION_LABEL;
    public static final String MOD_ID = "craftpresence";
    public static final int MOD_SCHEMA_VERSION = 2;
    public static final String GUI_FACTORY = "com.gitlab.cdagaming.craftpresence.config.ConfigGuiDataFactory";
    public static final String MCVersion;
    public static final int MCProtocolID;
    public static final String BRAND;
    public static final String configDir;
    public static final String modsDir;
    public static final String USERNAME;
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/CDAGaming/VersionLibrary/master/CraftPresence/update.json";
    public static final String FINGERPRINT = "eca02c6a597321ad22340897683951ba5c76720a";
    public static final ModLogger LOG;
    public static final ClassLoader CLASS_LOADER;
    public static final TranslationUtils TRANSLATOR;
    public static final ModUpdaterUtils UPDATER;
    public static final boolean IS_LEGACY_HARD = false;
    public static final boolean IS_LEGACY_SOFT = false;
    public static boolean forceBlockTooltipRendering;
    public static boolean IS_DEV;
    public static boolean IS_VERBOSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCharData(boolean Update, String encoding) {
        LOG.debugInfo(TRANSLATOR.translate("craftpresence.logger.info.chardata.init", new Object[0]), new Object[0]);
        String fileName = "chardata.properties";
        String charDataPath = "/assets/craftpresence/chardata.properties";
        File charDataDir = new File(MOD_ID + File.separator + "chardata.properties");
        boolean UpdateStatus = Update || !charDataDir.exists();
        boolean errored = false;
        InputStream inputData = null;
        InputStreamReader inputStream = null;
        OutputStream outputData = null;
        BufferedReader reader = null;
        if (UpdateStatus) {
            if (!charDataDir.getParentFile().exists() && !charDataDir.getParentFile().mkdirs()) {
                errored = true;
            }
            LOG.debugInfo(TRANSLATOR.translate("craftpresence.logger.info.download.init", "chardata.properties", charDataDir.getAbsolutePath(), "/assets/craftpresence/chardata.properties"), new Object[0]);
            inputData = FileUtils.getResourceAsStream(ModUtils.class, "/assets/craftpresence/chardata.properties");
            if (inputData != null) {
                try {
                    outputData = new FileOutputStream(charDataDir);
                    byte[] transferBuffer = new byte[inputData.available()];
                    int readBuffer = inputData.read(transferBuffer);
                    while (readBuffer != -1) {
                        outputData.write(transferBuffer, 0, readBuffer);
                        readBuffer = inputData.read(transferBuffer);
                    }
                    LOG.debugInfo(TRANSLATOR.translate("craftpresence.logger.info.download.loaded", "chardata.properties", charDataDir.getAbsolutePath(), "/assets/craftpresence/chardata.properties"), new Object[0]);
                }
                catch (Exception ex) {
                    errored = true;
                }
            } else {
                errored = true;
            }
        }
        if (!errored) {
            try {
                String currentString;
                inputData = new FileInputStream(charDataDir);
                inputStream = new InputStreamReader(inputData, Charset.forName(encoding));
                reader = new BufferedReader(inputStream);
                while ((currentString = reader.readLine()) != null) {
                    int i;
                    String[] localWidths;
                    if ((currentString = currentString.trim()).startsWith("=") || !currentString.contains("=")) continue;
                    String[] splitString = currentString.split("=", 2);
                    if (splitString[0].equalsIgnoreCase("charWidth")) {
                        localWidths = splitString[1].replaceAll("\\[", "").replaceAll("]", "").split(", ");
                        for (i = 0; i < localWidths.length && i <= 256; ++i) {
                            StringUtils.MC_CHAR_WIDTH[i] = Integer.parseInt(localWidths[i].trim());
                        }
                        continue;
                    }
                    if (!splitString[0].equalsIgnoreCase("glyphWidth")) continue;
                    localWidths = splitString[1].replaceAll("\\[", "").replaceAll("]", "").split(", ");
                    for (i = 0; i < localWidths.length && i <= 65536; ++i) {
                        StringUtils.MC_GLYPH_WIDTH[i] = Byte.parseByte(localWidths[i].trim());
                    }
                }
                if (Arrays.equals(StringUtils.MC_CHAR_WIDTH, new int[256]) || Arrays.equals(StringUtils.MC_GLYPH_WIDTH, new byte[65536])) {
                    errored = true;
                }
            }
            catch (Exception ex) {
                ModUtils.loadCharData(true, "UTF-8");
            }
        }
        try {
            if (reader != null) {
                reader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputData != null) {
                inputData.close();
            }
            if (outputData != null) {
                outputData.close();
            }
        }
        catch (Exception ex) {
            LOG.debugError(TRANSLATOR.translate("craftpresence.logger.error.data.close", new Object[0]), new Object[0]);
            if (IS_VERBOSE) {
                ex.printStackTrace();
            }
        }
        finally {
            if (errored) {
                LOG.debugError(TRANSLATOR.translate("craftpresence.logger.error.chardata", new Object[0]), new Object[0]);
                forceBlockTooltipRendering = true;
            } else {
                LOG.debugInfo(TRANSLATOR.translate("craftpresence.logger.info.chardata.loaded", new Object[0]), new Object[0]);
                forceBlockTooltipRendering = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToCharData(String encoding) {
        ArrayList textData = Lists.newArrayList();
        FileInputStream inputData = null;
        InputStreamReader inputStream = null;
        OutputStream outputData = null;
        OutputStreamWriter outputStream = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        File charDataDir = new File(MOD_ID + File.separator + "chardata.properties");
        if (charDataDir.exists()) {
            try {
                String currentString;
                inputData = new FileInputStream(charDataDir);
                inputStream = new InputStreamReader((InputStream)inputData, Charset.forName(encoding));
                br = new BufferedReader(inputStream);
                while (!StringUtils.isNullOrEmpty(currentString = br.readLine())) {
                    if (!currentString.contains("=")) continue;
                    if (currentString.startsWith("charWidth")) {
                        textData.add("charWidth=" + Arrays.toString(StringUtils.MC_CHAR_WIDTH));
                        continue;
                    }
                    if (!currentString.startsWith("glyphWidth")) continue;
                    textData.add("glyphWidth=" + Arrays.toString(StringUtils.MC_GLYPH_WIDTH));
                }
                outputData = new FileOutputStream(charDataDir);
                outputStream = new OutputStreamWriter(outputData, Charset.forName(encoding));
                bw = new BufferedWriter(outputStream);
                if (!textData.isEmpty()) {
                    for (String lineInput : textData) {
                        bw.write(lineInput);
                        bw.newLine();
                    }
                }
                ModUtils.loadCharData(true, "UTF-8");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                block23: {
                    try {
                        if (br != null) {
                            br.close();
                        }
                        if (bw != null) {
                            bw.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (inputData != null) {
                            ((InputStream)inputData).close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        if (outputData != null) {
                            outputData.close();
                        }
                    }
                    catch (Exception ex) {
                        LOG.debugError(TRANSLATOR.translate("craftpresence.logger.error.data.close", new Object[0]), new Object[0]);
                        if (!IS_VERBOSE) break block23;
                        ex.printStackTrace();
                    }
                }
            }
        } else {
            ModUtils.loadCharData(true, "UTF-8");
        }
    }

    static {
        MCVersion = SharedConstants.m_183709_().getName();
        MCProtocolID = SharedConstants.m_183709_().getProtocolVersion();
        BRAND = ClientBrandRetriever.m_129629_();
        configDir = CraftPresence.SYSTEM.USER_DIR + File.separator + "config";
        modsDir = CraftPresence.SYSTEM.USER_DIR + File.separator + "mods";
        USERNAME = Minecraft.m_91087_().m_91094_().m_92546_();
        LOG = new ModLogger(MOD_ID);
        CLASS_LOADER = Thread.currentThread().getContextClassLoader();
        TRANSLATOR = new TranslationUtils(MOD_ID, true);
        forceBlockTooltipRendering = false;
        IS_DEV = false;
        IS_VERBOSE = false;
        NAME = "CraftPresence";
        VERSION_ID = "v1.8.8";
        VERSION_TYPE = "Release";
        VERSION_LABEL = "Release";
        UPDATER = new ModUpdaterUtils(MOD_ID, UPDATE_JSON, VERSION_ID, MCVersion);
    }
}

