/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.config.ConfigUtils;
import com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import com.gitlab.cdagaming.craftpresence.impl.DataConsumer;
import com.gitlab.cdagaming.craftpresence.impl.KeyConverter;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.glfw.GLFW;

public class KeyUtils {
    private final List<Integer> clearKeys = Lists.newArrayList();
    private final List<Integer> invalidKeys = Lists.newArrayList();
    private final Map<String, Tuple<KeyMapping, Runnable, DataConsumer<Throwable>>> KEY_MAPPINGS = Maps.newHashMap();

    void register() {
        this.clearKeys.add(ModUtils.MCProtocolID > 340 ? 256 : 1);
        this.KEY_MAPPINGS.put("configKeyCode", new Tuple<KeyMapping, Runnable, Object>(new KeyMapping("key.craftpresence.config_keycode.name", CraftPresence.CONFIG.configKeyCode, "key.craftpresence.category"), () -> {
            if (!CraftPresence.GUIS.isFocused && !CraftPresence.GUIS.configGUIOpened) {
                CraftPresence.GUIS.openScreen(new MainGui(CraftPresence.instance.f_91080_));
            }
        }, null));
        for (String keyName : this.KEY_MAPPINGS.keySet()) {
            CraftPresence.instance.f_91066_.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])CraftPresence.instance.f_91066_.f_92059_, (Object)this.KEY_MAPPINGS.get(keyName).getFirst());
        }
    }

    public boolean isValidKeyCode(int sourceKeyCode) {
        return !this.invalidKeys.contains(sourceKeyCode);
    }

    public boolean isValidClearCode(int sourceKeyCode) {
        return this.clearKeys.contains(sourceKeyCode);
    }

    public Map<String, Tuple<KeyMapping, Runnable, DataConsumer<Throwable>>> getRawKeyMappings() {
        return this.KEY_MAPPINGS;
    }

    public String getKeyName(String original) {
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0)).getSecond();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pair<Boolean, Integer> integerData = StringUtils.getValidInteger(original);
            if (integerData.getFirst().booleanValue()) {
                return this.getKeyName(integerData.getSecond());
            }
            return unknownKeyName;
        }
        return unknownKeyName;
    }

    public String getKeyName(int original) {
        int unknownKeyCode = ModUtils.MCProtocolID <= 340 ? -1 : 0;
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(unknownKeyCode) : KeyConverter.toGlfw.get(unknownKeyCode)).getSecond();
        if (this.isValidKeyCode(original)) {
            if (ModUtils.MCProtocolID <= 340 && KeyConverter.toGlfw.containsKey(original)) {
                return KeyConverter.toGlfw.get(original).getSecond();
            }
            if (ModUtils.MCProtocolID > 340 && KeyConverter.fromGlfw.containsKey(original)) {
                return KeyConverter.fromGlfw.get(original).getSecond();
            }
            String altKeyName = Integer.toString(original);
            String keyName = original != unknownKeyCode ? GLFW.glfwGetKeyName((int)original, (int)GLFW.glfwGetKeyScancode((int)original)) : unknownKeyName;
            if (!StringUtils.isNullOrEmpty(keyName)) {
                return keyName;
            }
            return altKeyName;
        }
        return unknownKeyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTick() {
        block14: {
            if (CraftPresence.instance.m_91268_() != null && CraftPresence.CONFIG != null) {
                int unknownKeyCode = ModUtils.MCProtocolID <= 340 ? -1 : 0;
                String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(unknownKeyCode) : KeyConverter.toGlfw.get(unknownKeyCode)).getSecond();
                try {
                    for (String keyName : this.KEY_MAPPINGS.keySet()) {
                        KeyMapping keyBind = this.KEY_MAPPINGS.get(keyName).getFirst();
                        int currentBind = keyBind.getKey().m_84873_();
                        boolean hasBeenRun = false;
                        if (!(this.getKeyName(currentBind).equals(unknownKeyName) || this.isValidClearCode(currentBind) || GLFW.glfwGetKey((long)CraftPresence.instance.m_91268_().m_85439_(), (int)currentBind) != 1 || CraftPresence.instance.f_91080_ instanceof ControlsScreen)) {
                            Tuple<KeyMapping, Runnable, DataConsumer<Throwable>> keyData = this.KEY_MAPPINGS.get(keyName);
                            try {
                                keyData.getSecond().run();
                            }
                            catch (Error | Exception ex) {
                                if (keyData.getThird() != null) {
                                    keyData.getThird().accept(ex);
                                } else {
                                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.keycode", keyBind.m_90860_()), new Object[0]);
                                    this.syncKeyData(keyName, ImportMode.Specific, keyBind.m_90861_().m_84873_());
                                }
                            }
                            finally {
                                hasBeenRun = true;
                            }
                        }
                        if (hasBeenRun || CraftPresence.CONFIG.hasChanged) continue;
                        if (CraftPresence.CONFIG.keySyncQueue.containsKey(keyName)) {
                            this.syncKeyData(keyName, ImportMode.Config, CraftPresence.CONFIG.keySyncQueue.get(keyName));
                            CraftPresence.CONFIG.keySyncQueue.remove(keyName);
                            continue;
                        }
                        if (currentBind == StringUtils.getValidInteger(StringUtils.lookupObject(ConfigUtils.class, CraftPresence.CONFIG, keyName)).getSecond()) continue;
                        this.syncKeyData(keyName, ImportMode.Vanilla, currentBind);
                    }
                }
                catch (Error | Exception ex) {
                    if (!ModUtils.IS_VERBOSE) break block14;
                    ex.printStackTrace();
                }
            }
        }
    }

    private void syncKeyData(String keyName, ImportMode mode, int keyCode) {
        Tuple keyData = this.KEY_MAPPINGS.getOrDefault(keyName, null);
        if (mode == ImportMode.Config) {
            ((KeyMapping)keyData.getFirst()).m_90848_(InputConstants.m_84827_((int)keyCode, (int)GLFW.glfwGetKeyScancode((int)keyCode)));
        } else if (mode == ImportMode.Vanilla) {
            StringUtils.updateField(ConfigUtils.class, CraftPresence.CONFIG, new Tuple<String, Integer, Object>(keyName, keyCode, null));
            CraftPresence.CONFIG.updateConfig(false);
        } else if (mode == ImportMode.Specific) {
            this.syncKeyData(((KeyMapping)keyData.getFirst()).m_90860_(), ImportMode.Config, keyCode);
            this.syncKeyData(keyName, ImportMode.Vanilla, keyCode);
        } else if (ModUtils.IS_VERBOSE) {
            ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", keyName, mode.name()), new Object[0]);
        }
    }

    public Map<String, Tuple<KeyMapping, Runnable, DataConsumer<Throwable>>> getKeyMappings(FilterMode mode, List<String> filterData) {
        HashMap filteredMappings = Maps.newHashMap();
        for (String keyName : this.KEY_MAPPINGS.keySet()) {
            if (mode != FilterMode.None && mode != FilterMode.Category && mode != FilterMode.Id && (mode != FilterMode.Name || !filterData.contains(keyName))) continue;
            Tuple<KeyMapping, Runnable, DataConsumer<Throwable>> keyData = this.KEY_MAPPINGS.get(keyName);
            if (!(mode == FilterMode.None || mode == FilterMode.Category && filterData.contains(keyData.getFirst().m_90858_()) || mode == FilterMode.Id && filterData.contains(keyData.getFirst().m_90860_())) && mode != FilterMode.Name) continue;
            filteredMappings.put(keyName, keyData);
        }
        return filteredMappings;
    }

    public Map<String, Tuple<KeyMapping, Runnable, DataConsumer<Throwable>>> getKeyMappings() {
        return this.getKeyMappings(FilterMode.None, Lists.newArrayList());
    }

    public static enum ImportMode {
        Config,
        Vanilla,
        Specific;

    }

    public static enum FilterMode {
        Category,
        Name,
        Id,
        None;

    }
}

