/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class ExtendedButtonControl
extends Button {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private Font currentFontRender = null;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, (Component)new TextComponent(buttonText), button -> {});
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.onPushEvent = onPushEvent;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.onHoverEvent = onHoverEvent;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, (Component)new TextComponent(buttonText), button -> {});
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        this(xPos, yPos, 200, 20, displayString, new String[0]);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(CraftPresence.GUIS.getNextIndex(), xPos, yPos, displayString);
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            this.f_93622_ = CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, this);
            int hoverState = this.m_7202_(this.f_93622_);
            String backgroundCode = CraftPresence.CONFIG.buttonBackgroundColor;
            if (StringUtils.isValidColorCode(backgroundCode)) {
                CraftPresence.GUIS.drawGradientRect(this.m_93252_(), this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), backgroundCode, backgroundCode);
            } else {
                ResourceLocation texLocation;
                boolean usingExternalTexture = ImageUtils.isExternalImage(backgroundCode);
                if (!usingExternalTexture) {
                    if (backgroundCode.contains(CraftPresence.CONFIG.splitCharacter)) {
                        backgroundCode = backgroundCode.replace(CraftPresence.CONFIG.splitCharacter, ":");
                    }
                    if (backgroundCode.contains(":")) {
                        String[] splitInput = backgroundCode.split(":", 2);
                        texLocation = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        texLocation = new ResourceLocation(backgroundCode);
                    }
                } else {
                    String formattedConvertedName = backgroundCode.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    texLocation = ImageUtils.getTextureFromUrl(textureName, backgroundCode.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                }
                CraftPresence.GUIS.renderButton(this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), hoverState, this.m_93252_(), texLocation);
            }
            this.m_7906_(matrixStack, CraftPresence.instance, mouseX, mouseY);
            int color = !this.f_93623_ ? 0xA0A0A0 : (this.f_93622_ ? 0xFFFFA0 : 0xE0E0E0);
            ExtendedButtonControl.m_93208_((PoseStack)matrixStack, (Font)this.getFontRenderer(), (String)this.getControlMessage(), (int)(this.getControlPosX() + this.getControlWidth() / 2), (int)(this.getControlPosY() + (this.getControlHeight() - 8) / 2), (int)color);
        }
    }

    public int getControlWidth() {
        return this.f_93618_;
    }

    public int getControlHeight() {
        return this.f_93619_;
    }

    public int getControlPosX() {
        return this.f_93620_;
    }

    public int getControlPosY() {
        return this.f_93621_;
    }

    public Font getFontRenderer() {
        return this.currentFontRender != null ? this.currentFontRender : GuiUtils.getDefaultFontRenderer();
    }

    public void setCurrentFontRender(Font currentFontRender) {
        this.currentFontRender = currentFontRender;
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public String[] getOptionalArgs() {
        return this.optionalArgs;
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.onClick();
        super.m_5716_(mouseX, mouseY);
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public Component getControlRawMessage() {
        return this.m_6035_();
    }

    public String getControlMessage() {
        return this.getControlRawMessage().getString();
    }

    public void setControlRawMessage(Component newMessage) {
        this.m_93666_(newMessage);
    }

    public void setControlMessage(String newMessage) {
        this.setControlRawMessage((Component)new TextComponent(newMessage));
    }

    public boolean isControlEnabled() {
        return this.f_93623_;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.f_93623_ = isEnabled;
    }

    public boolean isControlVisible() {
        return this.f_93624_;
    }

    public void setControlVisible(boolean isVisible) {
        this.f_93624_ = isVisible;
    }
}

