/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.config.ConfigUtils;
import com.gitlab.cdagaming.craftpresence.impl.DataConsumer;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.PaginatedScreen;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;

public class ControlsGui
extends PaginatedScreen {
    private final Map<String, Tuple<KeyMapping, Runnable, DataConsumer<Throwable>>> keyMappings;
    private final Map<String, List<String>> categorizedNames = Maps.newHashMap();
    private final Map<Integer, List<Tuple<String, Pair<Float, Float>, Integer>>> preRenderQueue = Maps.newHashMap();
    private final Map<Integer, List<Tuple<String, Pair<Float, Float>, Integer>>> postRenderQueue = Maps.newHashMap();
    private final int maxElementsPerPage = 7;
    private final int startRow = 1;
    private String backupKeyString;
    private Pair<ExtendedButtonControl, String> entryData = null;
    private int currentAllocatedRow = 1;
    private int currentAllocatedPage = this.startPage;

    public ControlsGui(Screen parentScreen) {
        super(parentScreen);
        this.keyMappings = CraftPresence.KEYBINDINGS.getKeyMappings();
        this.sortMappings();
    }

    public ControlsGui(Screen parentScreen, KeyUtils.FilterMode filterMode, List<String> filterData) {
        super(parentScreen);
        this.keyMappings = CraftPresence.KEYBINDINGS.getKeyMappings(filterMode, filterData);
        this.sortMappings();
    }

    public ControlsGui(Screen parentScreen, KeyUtils.FilterMode filterMode, String ... filterData) {
        this(parentScreen, filterMode, Arrays.asList(filterData));
    }

    @Override
    public void initializeUi() {
        this.setupScreenData();
        super.initializeUi();
        this.backButton.setOnClick(() -> {
            if (this.entryData == null) {
                CraftPresence.GUIS.openScreen(this.parentScreen);
            }
        });
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.message.button.controls", new Object[0]);
        this.renderString(mainTitle, (float)this.f_96543_ / 2.0f - (float)StringUtils.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.f_96543_ / 2.0f - (float)StringUtils.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        super.preRender();
        for (Integer pageNumber : this.preRenderQueue.keySet()) {
            List<Tuple<String, Pair<Float, Float>, Integer>> elementList = this.preRenderQueue.get(pageNumber);
            for (Tuple<String, Pair<Float, Float>, Integer> elementData : elementList) {
                this.renderString(ModUtils.TRANSLATOR.translate(elementData.getFirst(), new Object[0]), elementData.getSecond().getFirst().floatValue(), elementData.getSecond().getSecond().floatValue(), elementData.getThird(), pageNumber);
            }
        }
    }

    @Override
    public void postRender() {
        for (Integer pageNumber : this.postRenderQueue.keySet()) {
            List<Tuple<String, Pair<Float, Float>, Integer>> elementList = this.postRenderQueue.get(pageNumber);
            for (Tuple<String, Pair<Float, Float>, Integer> elementData : elementList) {
                if (this.currentPage != pageNumber || !CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), elementData.getSecond().getFirst().floatValue(), elementData.getSecond().getSecond().floatValue(), StringUtils.getStringWidth(ModUtils.TRANSLATOR.translate(elementData.getFirst(), new Object[0])), this.getFontHeight())) continue;
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate(elementData.getFirst().replace(".name", ".description"), new Object[0])), this.getMouseX(), this.getMouseY(), this.f_96543_, this.f_96544_, this.getWrapWidth(), this.getFontRenderer(), true);
            }
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int mouseX, int mouseY) {
        if (this.entryData != null) {
            this.setKeyData(keyCode);
            return true;
        }
        return super.m_7933_(keyCode, mouseX, mouseY);
    }

    private void sortMappings() {
        for (String keyName : this.keyMappings.keySet()) {
            Tuple<KeyMapping, Runnable, DataConsumer<Throwable>> keyData = this.keyMappings.get(keyName);
            if (!this.categorizedNames.containsKey(keyData.getFirst().m_90858_())) {
                this.categorizedNames.put(keyData.getFirst().m_90858_(), Lists.newArrayList((Object[])new String[]{keyName}));
                continue;
            }
            if (this.categorizedNames.get(keyData.getFirst().m_90858_()).contains(keyName)) continue;
            this.categorizedNames.get(keyData.getFirst().m_90858_()).add(keyName);
        }
    }

    private void setupScreenData() {
        this.preRenderQueue.clear();
        this.postRenderQueue.clear();
        int renderPosition = this.f_96543_ / 2 + 3;
        for (String categoryName : this.categorizedNames.keySet()) {
            this.syncPageData();
            Tuple<String, Pair<Float, Float>, Integer> categoryData = new Tuple<String, Pair<Float, Float>, Integer>(categoryName, new Pair<Float, Float>(Float.valueOf((float)this.f_96543_ / 2.0f - (float)StringUtils.getStringWidth(categoryName) / 2.0f), Float.valueOf(CraftPresence.GUIS.getButtonY(this.currentAllocatedRow, 5))), 0xFFFFFF);
            if (!this.preRenderQueue.containsKey(this.currentAllocatedPage)) {
                this.preRenderQueue.put(this.currentAllocatedPage, Lists.newArrayList());
            }
            this.preRenderQueue.get(this.currentAllocatedPage).add(categoryData);
            List<String> keyNames = this.categorizedNames.get(categoryName);
            ++this.currentAllocatedRow;
            for (String keyName : keyNames) {
                Tuple<KeyMapping, Runnable, DataConsumer<Throwable>> keyData = this.keyMappings.get(keyName);
                Tuple<String, Pair<Float, Float>, Integer> positionData = new Tuple<String, Pair<Float, Float>, Integer>(keyData.getFirst().m_90860_(), new Pair<Float, Float>(Float.valueOf((float)this.f_96543_ / 2.0f - 130.0f), Float.valueOf(CraftPresence.GUIS.getButtonY(this.currentAllocatedRow, 5))), 0xFFFFFF);
                if (!this.preRenderQueue.containsKey(this.currentAllocatedPage)) {
                    this.preRenderQueue.put(this.currentAllocatedPage, Lists.newArrayList((Object[])new Tuple[]{positionData}));
                } else {
                    this.preRenderQueue.get(this.currentAllocatedPage).add(positionData);
                }
                if (!this.postRenderQueue.containsKey(this.currentAllocatedPage)) {
                    this.postRenderQueue.put(this.currentAllocatedPage, Lists.newArrayList((Object[])new Tuple[]{positionData}));
                } else {
                    this.postRenderQueue.get(this.currentAllocatedPage).add(positionData);
                }
                ExtendedButtonControl keyCodeButton = new ExtendedButtonControl(renderPosition + 20, CraftPresence.GUIS.getButtonY(this.currentAllocatedRow), 120, 20, CraftPresence.KEYBINDINGS.getKeyName(keyData.getFirst().getKey().m_84873_()), keyName);
                keyCodeButton.setOnClick(() -> this.setupEntryData(keyCodeButton));
                this.addControl(keyCodeButton, this.currentAllocatedPage);
                ++this.currentAllocatedRow;
                this.syncPageData();
            }
        }
    }

    private void syncPageData() {
        if (this.currentAllocatedRow >= 7) {
            ++this.currentAllocatedPage;
            this.currentAllocatedRow = 1;
        }
    }

    private void setupEntryData(ExtendedButtonControl button) {
        if (this.entryData == null && button.getOptionalArgs() != null) {
            this.entryData = new Pair<ExtendedButtonControl, String>(button, button.getOptionalArgs()[0]);
            this.backupKeyString = button.getControlMessage();
            button.setControlMessage(ModUtils.TRANSLATOR.translate("gui.config.message.editor.enter_key", new Object[0]));
        }
    }

    private void setKeyData(int keyCode) {
        int keyToSubmit = keyCode;
        if (!CraftPresence.KEYBINDINGS.isValidKeyCode(keyToSubmit) || CraftPresence.KEYBINDINGS.isValidClearCode(keyToSubmit)) {
            keyToSubmit = -1;
        }
        String formattedKey = CraftPresence.KEYBINDINGS.getKeyName(keyToSubmit);
        try {
            StringUtils.updateField(ConfigUtils.class, CraftPresence.CONFIG, new Tuple<String, Integer, Object>(this.entryData.getSecond(), keyToSubmit, null));
            CraftPresence.CONFIG.keySyncQueue.put(this.entryData.getSecond(), keyToSubmit);
            CraftPresence.CONFIG.hasChanged = true;
            this.entryData.getFirst().setControlMessage(formattedKey);
        }
        catch (Error | Exception ex) {
            this.entryData.getFirst().setControlMessage(this.backupKeyString);
            ex.printStackTrace();
        }
        this.backupKeyString = null;
        this.entryData = null;
    }
}

