/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ExtendedScreen
extends Screen {
    public final Screen parentScreen;
    public final Screen currentScreen;
    protected final List<GuiEventListener> extendedControls = Lists.newArrayList();
    protected final List<ScrollableListControl> extendedLists = Lists.newArrayList();
    protected PoseStack currentMatrix = new PoseStack();
    private boolean initialized = false;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int lastMouseX = 0;
    private int lastMouseY = 0;

    public ExtendedScreen(Screen parentScreen) {
        super((Component)new TextComponent(""));
        this.f_96541_ = CraftPresence.instance;
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.setDebugMode(ModUtils.IS_DEV);
        this.setVerboseMode(ModUtils.IS_VERBOSE);
    }

    public ExtendedScreen(Screen parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(Screen parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public void m_7856_() {
        this.m_169413_();
        this.extendedControls.clear();
        this.extendedLists.clear();
        this.f_96541_.f_91068_.m_90926_(true);
        this.initializeUi();
        super.m_7856_();
        this.initialized = true;
    }

    public void initializeUi() {
    }

    public void m_6574_(@Nonnull Minecraft mcIn, int w, int h) {
        this.initialized = false;
        super.m_6574_(mcIn, w, h);
    }

    @Nonnull
    protected <T extends GuiEventListener & Widget> T addControl(@Nonnull T buttonIn) {
        if (buttonIn instanceof Widget) {
            this.m_169394_(buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    protected <T extends ScrollableListControl> T addList(@Nonnull T buttonIn) {
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        CraftPresence.GUIS.drawBackground(this.f_96543_, this.f_96544_);
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentMatrix = matrixStack;
        if (this.initialized) {
            this.renderCriticalData();
            this.preRender();
            for (ScrollableListControl listControl : this.extendedLists) {
                if (!listControl.isVisible()) continue;
                listControl.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            }
            for (GuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            }
            super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            for (GuiEventListener extendedControl : this.extendedControls) {
                ExtendedButtonControl extendedButton;
                if (!(extendedControl instanceof ExtendedButtonControl) || !CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, extendedButton = (ExtendedButtonControl)extendedControl)) continue;
                extendedButton.onHover();
            }
            this.postRender();
        }
    }

    public boolean m_7933_(int keyCode, int mouseX, int mouseY) {
        if (this.initialized) {
            if (keyCode == 256) {
                CraftPresence.GUIS.openScreen(this.parentScreen);
            }
            for (GuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.m_7933_(keyCode, mouseX, mouseY);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.m_7933_(keyCode, mouseX, mouseY);
            }
        }
        return super.m_7933_(keyCode, mouseX, mouseY);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.m_5534_(typedChar, keyCode);
            }
            for (GuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.m_5534_(typedChar, keyCode);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.m_5534_(typedChar, keyCode);
            }
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.m_6375_(mouseX, mouseY, mouseButton);
            }
            for (GuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.m_6375_(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.m_6375_(mouseX, mouseY, mouseButton);
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.m_6050_(mouseX, mouseY, scrollAmount);
            }
            for (GuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.m_6050_(mouseX, mouseY, scrollAmount);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.m_6050_(mouseX, mouseY, scrollAmount);
            }
        }
        return super.m_6050_(mouseX, mouseY, scrollAmount);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double scrollX, double scrollY) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.m_7979_(mouseX, mouseY, mouseButton, scrollX, scrollY);
            }
            for (GuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.m_7979_(mouseX, mouseY, mouseButton, scrollX, scrollY);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.m_7979_(mouseX, mouseY, mouseButton, scrollX, scrollY);
            }
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, scrollX, scrollY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.m_6348_(mouseX, mouseY, mouseButton);
            }
            for (GuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.m_6348_(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.m_6348_(mouseX, mouseY, mouseButton);
            }
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public void m_96624_() {
        if (this.initialized) {
            for (GuiEventListener extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.m_94120_();
            }
        }
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_7379_() {
        this.initialized = false;
        CraftPresence.GUIS.resetIndex();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void renderNotice(List<String> notice) {
        this.renderNotice(notice, 2.0f, 3.0f, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale) {
        this.renderNotice(notice, widthScale, heightScale, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale, boolean useXAsActual, boolean useYAsActual) {
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = notice.get(i);
                this.renderString(string, (useXAsActual ? widthScale : (float)this.f_96543_ / widthScale) - (float)StringUtils.getStringWidth(string) / widthScale, (useYAsActual ? heightScale : (float)this.f_96544_ / heightScale) + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.getFontRenderer().m_92750_(this.currentMatrix, text, xPos, yPos, color);
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public Font getFontRenderer() {
        return this.f_96541_.f_91062_ != null ? this.f_96541_.f_91062_ : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }
}

