/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.server;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.PartyPrivacy;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;

public class ServerUtils {
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<PlayerInfo> currentPlayerList = Lists.newArrayList();
    public List<String> knownAddresses = Lists.newArrayList();
    public Map<String, ServerData> knownServerData = Maps.newHashMap();
    private String currentServer_IP;
    private String currentServer_Name;
    private String currentServer_MOTD;
    private String currentServerMessage;
    private String timeString;
    private String currentDifficulty;
    private String currentWorldName;
    private int currentPlayers;
    private int maxPlayers;
    private int serverIndex;
    private Tuple<Double, Double, Double> currentCoordinates = new Tuple<Double, Double, Double>(0.0, 0.0, 0.0);
    private Pair<Double, Double> currentHealth = new Pair<Double, Double>(0.0, 0.0);
    private ServerData currentServerData;
    private ServerData requestedServerData;
    private ClientPacketListener currentConnection;
    private boolean queuedForUpdate = false;
    private boolean joinInProgress = false;
    private boolean isOnLAN = false;

    private void emptyData() {
        this.currentPlayerList.clear();
        this.knownAddresses.clear();
        this.knownServerData.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.currentServer_IP = null;
        this.currentServer_MOTD = null;
        this.currentServer_Name = null;
        this.currentServerData = null;
        this.currentConnection = null;
        this.currentCoordinates = new Tuple<Double, Double, Double>(0.0, 0.0, 0.0);
        this.currentHealth = new Pair<Double, Double>(0.0, 0.0);
        this.currentDifficulty = null;
        this.currentWorldName = null;
        this.timeString = null;
        this.currentPlayers = 0;
        this.maxPlayers = 0;
        this.queuedForUpdate = false;
        this.isOnLAN = false;
        this.isInUse = false;
        if (!this.joinInProgress) {
            this.requestedServerData = null;
        }
        CraftPresence.CLIENT.initArgument("&SERVER&");
        CraftPresence.CLIENT.clearPartyData(true, false);
    }

    public void onTick() {
        boolean needsUpdate;
        this.joinInProgress = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinGame || CraftPresence.CLIENT.STATUS == DiscordStatus.SpectateGame;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectWorldData : this.enabled;
        boolean bl = needsUpdate = this.enabled && this.knownAddresses.isEmpty();
        if (needsUpdate) {
            this.getServerAddresses();
        }
        if (this.enabled) {
            if (CraftPresence.player != null && !this.joinInProgress) {
                this.isInUse = true;
                this.updateServerData();
            } else {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
        if (this.joinInProgress && this.requestedServerData != null) {
            CraftPresence.instance.execute(() -> this.joinServer(this.requestedServerData));
        }
    }

    private void updateServerData() {
        ServerData newServerData = CraftPresence.instance.m_91089_();
        ClientPacketListener newConnection = CraftPresence.instance.m_91403_();
        if (!this.joinInProgress) {
            String newServer_MOTD;
            int newMaxPlayers;
            int newCurrentPlayers;
            ArrayList newPlayerList = newConnection != null ? Lists.newArrayList((Iterable)newConnection.m_105142_()) : Lists.newArrayList();
            int n = newCurrentPlayers = newConnection != null ? newConnection.m_105142_().size() : 1;
            if (newServerData != null) {
                try {
                    newMaxPlayers = StringUtils.getValidInteger(StringUtils.stripColors(newServerData.f_105364_.getString()).split("/")[1]).getSecond();
                    if (newMaxPlayers < newCurrentPlayers) {
                        newMaxPlayers = newCurrentPlayers + 1;
                    }
                }
                catch (Exception ex) {
                    newMaxPlayers = newCurrentPlayers + 1;
                }
            } else {
                newMaxPlayers = newCurrentPlayers + 1;
            }
            boolean newLANStatus = CraftPresence.instance.m_91090_() && newCurrentPlayers > 1 || newServerData != null && newServerData.m_105389_();
            boolean isMotdValid = newServerData != null && newServerData.f_105365_ != null && !StringUtils.isNullOrEmpty(newServerData.f_105365_.getString());
            String newServer_IP = newServerData != null && !StringUtils.isNullOrEmpty(newServerData.f_105363_) ? newServerData.f_105363_ : "127.0.0.1";
            String newServer_Name = newServerData != null && !StringUtils.isNullOrEmpty(newServerData.f_105362_) ? newServerData.f_105362_ : CraftPresence.CONFIG.defaultServerName;
            String string = newServer_MOTD = !this.isOnLAN && !CraftPresence.instance.m_91090_() && newServerData != null && isMotdValid && !newServerData.f_105365_.getString().equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.cannot_connect", new Object[0])) && !newServerData.f_105365_.getString().equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.cannot_resolve", new Object[0])) && !newServerData.f_105365_.getString().equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.polling", new Object[0])) && !newServerData.f_105365_.getString().equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.pinging", new Object[0])) ? StringUtils.stripColors(newServerData.f_105365_.getString()) : CraftPresence.CONFIG.defaultServerMotd;
            if (newLANStatus != this.isOnLAN || newServerData != null && !newServerData.equals(this.currentServerData) || newServerData == null && this.currentServerData != null || newConnection != null && !newConnection.equals(this.currentConnection) || !newServer_IP.equals(this.currentServer_IP) || !StringUtils.isNullOrEmpty(newServer_MOTD) && !newServer_MOTD.equals(this.currentServer_MOTD) || !StringUtils.isNullOrEmpty(newServer_Name) && !newServer_Name.equals(this.currentServer_Name)) {
                this.currentServer_IP = newServer_IP;
                this.currentServer_MOTD = newServer_MOTD;
                this.currentServer_Name = newServer_Name;
                this.currentServerData = newServerData;
                this.currentConnection = newConnection;
                this.isOnLAN = newLANStatus;
                this.queuedForUpdate = true;
                if (!StringUtils.isNullOrEmpty(this.currentServer_IP) && !this.knownAddresses.contains(this.currentServer_IP.contains(":") ? this.currentServer_IP : StringUtils.formatAddress(this.currentServer_IP, false))) {
                    this.knownAddresses.add(this.currentServer_IP.contains(":") ? this.currentServer_IP : StringUtils.formatAddress(this.currentServer_IP, false));
                }
                ServerList serverList = new ServerList(CraftPresence.instance);
                serverList.m_105431_();
                if (serverList.m_105445_() != this.serverIndex || CraftPresence.CONFIG.serverMessages.length != this.serverIndex) {
                    this.getServerAddresses();
                }
            }
            if (!StringUtils.isNullOrEmpty(this.currentServerMessage)) {
                if (this.currentServerMessage.toLowerCase().contains("&playerinfo&")) {
                    if (CraftPresence.CONFIG.innerPlayerPlaceholderMessage.toLowerCase().contains("&coords&")) {
                        double newX = StringUtils.roundDouble(CraftPresence.player != null ? CraftPresence.player.m_20185_() : 0.0, CraftPresence.CONFIG.roundSize);
                        double newY = StringUtils.roundDouble(CraftPresence.player != null ? CraftPresence.player.m_20186_() : 0.0, CraftPresence.CONFIG.roundSize);
                        double newZ = StringUtils.roundDouble(CraftPresence.player != null ? CraftPresence.player.m_20189_() : 0.0, CraftPresence.CONFIG.roundSize);
                        Tuple<Double, Double, Double> newCoordinates = new Tuple<Double, Double, Double>(newX, newY, newZ);
                        if (!newCoordinates.equals(this.currentCoordinates)) {
                            this.currentCoordinates = newCoordinates;
                            this.queuedForUpdate = true;
                        }
                    }
                    if (CraftPresence.CONFIG.innerPlayerPlaceholderMessage.toLowerCase().contains("&health&")) {
                        Pair<Double, Double> newHealth;
                        Pair<Double, Double> pair = newHealth = CraftPresence.player != null ? new Pair<Double, Double>(StringUtils.roundDouble(CraftPresence.player.m_21223_(), 0), StringUtils.roundDouble(CraftPresence.player.m_21233_(), 0)) : new Pair<Double, Double>(0.0, 0.0);
                        if (!newHealth.equals(this.currentHealth)) {
                            this.currentHealth = newHealth;
                            this.queuedForUpdate = true;
                        }
                    }
                }
                if (this.currentServerMessage.toLowerCase().contains("&worldinfo&")) {
                    if (CraftPresence.CONFIG.worldPlaceholderMessage.toLowerCase().contains("&difficulty&")) {
                        String newDifficulty;
                        String string2 = CraftPresence.player != null ? (CraftPresence.player.f_19853_.m_6106_().m_5466_() ? ModUtils.TRANSLATOR.translate("craftpresence.defaults.mode.hardcore", new Object[0]) : CraftPresence.player.f_19853_.m_46791_().name()) : (newDifficulty = "");
                        if (!newDifficulty.equals(this.currentDifficulty)) {
                            this.currentDifficulty = newDifficulty;
                            this.queuedForUpdate = true;
                        }
                    }
                    if (CraftPresence.CONFIG.worldPlaceholderMessage.toLowerCase().contains("&worldname&")) {
                        String newWorldName = "";
                        if (CraftPresence.instance.m_91091_()) {
                            newWorldName = Objects.requireNonNull(CraftPresence.instance.m_91092_()).m_129910_().m_5462_();
                        } else if (CraftPresence.player != null && CraftPresence.player.f_19853_.m_142572_() != null) {
                            newWorldName = CraftPresence.player.f_19853_.m_142572_().m_129910_().m_5462_();
                        }
                        if (!newWorldName.equals(this.currentWorldName)) {
                            this.currentWorldName = newWorldName;
                            this.queuedForUpdate = true;
                        }
                    }
                    if (CraftPresence.CONFIG.worldPlaceholderMessage.toLowerCase().contains("&worldtime&")) {
                        String newGameTime;
                        String string3 = newGameTime = CraftPresence.player != null ? this.getTimeString(CraftPresence.player.f_19853_.m_46468_()) : null;
                        if (!StringUtils.isNullOrEmpty(newGameTime) && !newGameTime.equals(this.timeString)) {
                            this.timeString = newGameTime;
                            this.queuedForUpdate = true;
                        }
                    }
                }
                if ((this.currentServerMessage.toLowerCase().contains("&players&") || CraftPresence.CONFIG.enableJoinRequest) && (newCurrentPlayers != this.currentPlayers || newMaxPlayers != this.maxPlayers)) {
                    this.currentPlayers = newCurrentPlayers;
                    this.maxPlayers = newMaxPlayers;
                    this.queuedForUpdate = true;
                }
            }
            if (!newPlayerList.equals(this.currentPlayerList)) {
                this.currentPlayerList = newPlayerList;
                if (CraftPresence.ENTITIES.enabled) {
                    CraftPresence.ENTITIES.getEntities();
                }
            }
        }
        if (this.queuedForUpdate) {
            this.updateServerPresence();
        }
    }

    private String getTimeString(long worldTime) {
        long remainingTicks;
        long hour = 0L;
        long minute = 0L;
        long dayLength = 24000L;
        for (remainingTicks = worldTime % dayLength; remainingTicks >= 1000L; remainingTicks -= 1000L) {
            if (++hour <= 24L) continue;
            hour -= 24L;
        }
        remainingTicks *= 3L;
        while (remainingTicks >= 50L) {
            remainingTicks -= 50L;
            ++minute;
        }
        String formattedHour = String.valueOf(hour).length() == 1 ? String.format("%02d", hour) : String.valueOf(hour);
        String formattedMinute = String.valueOf(minute).length() == 1 ? String.format("%02d", minute) : String.valueOf(minute);
        return formattedHour + ":" + formattedMinute;
    }

    private String makeSecret() {
        String formattedKey = CraftPresence.CLIENT.CLIENT_ID;
        boolean containsServerName = false;
        boolean containsServerIP = false;
        if (!StringUtils.isNullOrEmpty(this.currentServer_Name)) {
            formattedKey = formattedKey + "-" + this.currentServer_Name.toLowerCase();
            containsServerName = true;
        }
        if (!StringUtils.isNullOrEmpty(this.currentServer_IP)) {
            formattedKey = formattedKey + "-" + this.currentServer_IP.toLowerCase();
            containsServerIP = true;
        }
        formattedKey = formattedKey + ";" + containsServerName + ";" + containsServerIP;
        return formattedKey;
    }

    public void verifyAndJoin(String secret) {
        boolean isValidSecret;
        String[] boolParts = secret.split(";");
        String[] stringParts = boolParts[0].split("-");
        boolean containsValidClientID = StringUtils.elementExists(stringParts, 0) && stringParts[0].length() == 18 && StringUtils.getValidLong(stringParts[0]).getFirst() != false;
        boolean containsServerName = StringUtils.elementExists(boolParts, 1) && StringUtils.elementExists(stringParts, 1) && Boolean.parseBoolean(boolParts[1]);
        boolean containsServerIP = StringUtils.elementExists(boolParts, 2) && StringUtils.elementExists(stringParts, 2) && Boolean.parseBoolean(boolParts[2]);
        String serverName = containsServerName ? stringParts[1] : CraftPresence.CONFIG.defaultServerName;
        String serverIP = containsServerIP ? stringParts[2] : "";
        boolean bl = isValidSecret = boolParts.length <= 4 && stringParts.length <= 3 && containsValidClientID;
        if (isValidSecret) {
            if (CraftPresence.CONFIG.enableJoinRequest) {
                this.requestedServerData = new ServerData(serverName, serverIP, false);
            } else {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.config.disabled.enable_join_request", new Object[0]), new Object[0]);
            }
        } else {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.discord.join", secret), new Object[0]);
        }
    }

    private void joinServer(ServerData serverData) {
        try {
            ConnectScreen.m_169267_((Screen)(CraftPresence.instance.f_91080_ != null ? CraftPresence.instance.f_91080_ : new TitleScreen()), (Minecraft)CraftPresence.instance, (ServerAddress)ServerAddress.m_171864_((String)serverData.f_105363_), (ServerData)serverData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.requestedServerData = null;
        }
    }

    public void updateServerPresence() {
        ArrayList playerDataArgs = Lists.newArrayList();
        ArrayList worldDataArgs = Lists.newArrayList();
        ArrayList coordinateArgs = Lists.newArrayList();
        ArrayList healthArgs = Lists.newArrayList();
        coordinateArgs.add(new Pair<String, String>("&xPosition&", this.currentCoordinates.getFirst().toString()));
        coordinateArgs.add(new Pair<String, String>("&yPosition&", this.currentCoordinates.getSecond().toString()));
        coordinateArgs.add(new Pair<String, String>("&zPosition&", this.currentCoordinates.getThird().toString()));
        healthArgs.add(new Pair<String, String>("&CURRENT&", this.currentHealth.getFirst().toString()));
        healthArgs.add(new Pair<String, String>("&MAX&", this.currentHealth.getSecond().toString()));
        playerDataArgs.add(new Pair<String, String>("&COORDS&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.playerCoordinatePlaceholderMessage, coordinateArgs)));
        playerDataArgs.add(new Pair<String, String>("&HEALTH&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.playerHealthPlaceholderMessage, healthArgs)));
        worldDataArgs.add(new Pair<String, String>("&DIFFICULTY&", !StringUtils.isNullOrEmpty(this.currentDifficulty) ? this.currentDifficulty : ""));
        worldDataArgs.add(new Pair<String, String>("&WORLDNAME&", !StringUtils.isNullOrEmpty(this.currentWorldName) ? this.currentWorldName : ""));
        worldDataArgs.add(new Pair<String, String>("&WORLDTIME&", !StringUtils.isNullOrEmpty(this.timeString) ? this.timeString : ""));
        if (!CraftPresence.instance.m_91090_() && this.currentServerData != null) {
            String CURRENT_SERVER_ICON;
            ArrayList serverArgs = Lists.newArrayList();
            ArrayList playerAmountArgs = Lists.newArrayList();
            playerAmountArgs.add(new Pair<String, String>("&CURRENT&", Integer.toString(this.currentPlayers)));
            playerAmountArgs.add(new Pair<String, String>("&MAX&", Integer.toString(this.maxPlayers)));
            serverArgs.add(new Pair<String, String>("&IP&", StringUtils.formatAddress(this.currentServer_IP, false)));
            serverArgs.add(new Pair<String, String>("&NAME&", this.currentServer_Name));
            serverArgs.add(new Pair<String, String>("&MOTD&", this.currentServer_MOTD));
            serverArgs.add(new Pair<String, String>("&PLAYERS&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.playerAmountPlaceholderMessage, playerAmountArgs)));
            serverArgs.add(new Pair<String, String>("&PLAYERINFO&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.innerPlayerPlaceholderMessage, playerDataArgs)));
            serverArgs.add(new Pair<String, String>("&WORLDINFO&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.worldPlaceholderMessage, worldDataArgs)));
            if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
                serverArgs.addAll(CraftPresence.CLIENT.generalArgs);
            }
            if (this.isOnLAN) {
                String alternateServerIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, this.currentServer_Name, 0, 2, CraftPresence.CONFIG.splitCharacter, this.currentServer_Name);
                String currentServerIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, StringUtils.formatAddress(this.currentServer_IP, false), 0, 2, CraftPresence.CONFIG.splitCharacter, alternateServerIcon);
                String formattedServerIconKey = StringUtils.formatAsIcon(currentServerIcon.replace(" ", "_"));
                CURRENT_SERVER_ICON = formattedServerIconKey.replace("&icon&", CraftPresence.CONFIG.defaultServerIcon);
                this.currentServerMessage = CraftPresence.CONFIG.lanMessage;
            } else {
                String defaultServerMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
                String alternateServerMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, this.currentServer_Name, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultServerMessage);
                String alternateServerIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, this.currentServer_Name, 0, 2, CraftPresence.CONFIG.splitCharacter, this.currentServer_Name);
                this.currentServerMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, StringUtils.formatAddress(this.currentServer_IP, false), 0, 1, CraftPresence.CONFIG.splitCharacter, alternateServerMessage);
                String currentServerIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, StringUtils.formatAddress(this.currentServer_IP, false), 0, 2, CraftPresence.CONFIG.splitCharacter, alternateServerIcon);
                String formattedServerIconKey = StringUtils.formatAsIcon(currentServerIcon.replace(" ", "_"));
                CURRENT_SERVER_ICON = formattedServerIconKey.replace("&icon&", CraftPresence.CONFIG.defaultServerIcon);
                if (CraftPresence.CONFIG.enableJoinRequest) {
                    CraftPresence.CLIENT.PARTY_ID = !StringUtils.isNullOrEmpty(this.currentServer_Name) && !this.currentServer_Name.equalsIgnoreCase(CraftPresence.CONFIG.defaultServerName) ? "Join Server: " + this.currentServer_Name : "Join Server: " + this.currentServer_IP;
                    CraftPresence.CLIENT.JOIN_SECRET = this.makeSecret();
                    CraftPresence.CLIENT.PARTY_SIZE = this.currentPlayers;
                    CraftPresence.CLIENT.PARTY_MAX = this.maxPlayers;
                    CraftPresence.CLIENT.PARTY_PRIVACY = PartyPrivacy.from(CraftPresence.CONFIG.partyPrivacyLevel % 2);
                }
            }
            CraftPresence.CLIENT.syncArgument("&SERVER&", StringUtils.sequentialReplaceAnyCase(this.currentServerMessage, serverArgs), false);
            CraftPresence.CLIENT.syncArgument("&SERVER&", CraftPresence.CLIENT.imageOf(CURRENT_SERVER_ICON, CraftPresence.CONFIG.defaultServerIcon, true), true);
            this.queuedForUpdate = false;
        } else if (CraftPresence.instance.m_91090_()) {
            ArrayList soloArgs = Lists.newArrayList();
            soloArgs.add(new Pair<String, String>("&PLAYERINFO&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.innerPlayerPlaceholderMessage, playerDataArgs)));
            soloArgs.add(new Pair<String, String>("&WORLDINFO&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.worldPlaceholderMessage, worldDataArgs)));
            if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
                soloArgs.addAll(CraftPresence.CLIENT.generalArgs);
            }
            this.currentServerMessage = CraftPresence.CONFIG.singlePlayerMessage;
            CraftPresence.CLIENT.syncArgument("&SERVER&", StringUtils.sequentialReplaceAnyCase(this.currentServerMessage, soloArgs), false);
            CraftPresence.CLIENT.initArgument(true, "&SERVER&");
            this.queuedForUpdate = false;
        }
    }

    public void getServerAddresses() {
        block5: {
            try {
                ServerList serverList = new ServerList(CraftPresence.instance);
                serverList.m_105431_();
                this.serverIndex = serverList.m_105445_();
                for (int currentIndex = 0; currentIndex < this.serverIndex; ++currentIndex) {
                    ServerData data = serverList.m_105432_(currentIndex);
                    if (!StringUtils.isNullOrEmpty(data.f_105363_) && !this.knownAddresses.contains(data.f_105363_.contains(":") ? StringUtils.formatAddress(data.f_105363_, false) : data.f_105363_)) {
                        this.knownAddresses.add(data.f_105363_.contains(":") ? StringUtils.formatAddress(data.f_105363_, false) : data.f_105363_);
                    }
                    if (StringUtils.isNullOrEmpty(data.f_105363_) || this.knownServerData.containsKey(data.f_105363_)) continue;
                    this.knownServerData.put(data.f_105363_, data);
                }
            }
            catch (Exception ex) {
                if (!ModUtils.IS_VERBOSE) break block5;
                ex.printStackTrace();
            }
        }
        for (String serverMessage : CraftPresence.CONFIG.serverMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(serverMessage) || StringUtils.isNullOrEmpty((part = serverMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.knownAddresses.contains(part[0])) continue;
            this.knownAddresses.add(part[0]);
        }
    }

    public ServerData getDataFromName(String serverAddress) {
        return this.knownServerData.getOrDefault(serverAddress, null);
    }
}

