/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeUtils {
    private final List<ResourceLocation> BIOME_TYPES = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> BIOME_NAMES = Lists.newArrayList();
    private String CURRENT_BIOME_NAME;

    private void emptyData() {
        this.BIOME_NAMES.clear();
        this.BIOME_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_BIOME_NAME = null;
        this.isInUse = false;
        CraftPresence.CLIENT.initArgument("&BIOME&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectBiomeData : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.BIOME_NAMES.isEmpty() || this.BIOME_TYPES.isEmpty());
        if (needsUpdate) {
            this.getBiomes();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateBiomeData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateBiomeData() {
        String newBiomeName;
        Biome newBiome = (Biome)CraftPresence.player.f_19853_.m_204166_(CraftPresence.player.m_142538_()).m_203334_();
        ResourceLocation newIdentifier = CraftPresence.player.f_19853_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)newBiome);
        String string = newIdentifier != null ? StringUtils.formatIdentifier(newIdentifier.toString(), false, !CraftPresence.CONFIG.formatWords) : (newBiomeName = "Plains");
        if (!newBiomeName.equals(this.CURRENT_BIOME_NAME)) {
            this.CURRENT_BIOME_NAME = newBiomeName;
            if (!this.BIOME_NAMES.contains(newBiomeName)) {
                this.BIOME_NAMES.add(newBiomeName);
            }
            if (!this.BIOME_TYPES.contains(newIdentifier)) {
                this.BIOME_TYPES.add(newIdentifier);
            }
            this.updateBiomePresence();
        }
    }

    public void updateBiomePresence() {
        ArrayList biomeArgs = Lists.newArrayList();
        biomeArgs.add(new Pair<String, String>("&BIOME&", this.CURRENT_BIOME_NAME));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            biomeArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String defaultBiomeMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentBiomeMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultBiomeMessage);
        String currentBiomeIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_NAME, 0, 2, CraftPresence.CONFIG.splitCharacter, this.CURRENT_BIOME_NAME);
        String formattedIconKey = StringUtils.formatAsIcon(currentBiomeIcon.replace(" ", "_"));
        String CURRENT_BIOME_ICON = formattedIconKey.replace("&icon&", CraftPresence.CONFIG.defaultBiomeIcon);
        String CURRENT_BIOME_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentBiomeMessage, biomeArgs);
        CraftPresence.CLIENT.syncArgument("&BIOME&", CURRENT_BIOME_MESSAGE, false);
        CraftPresence.CLIENT.syncArgument("&BIOME&", CraftPresence.CLIENT.imageOf(CURRENT_BIOME_ICON, CraftPresence.CONFIG.defaultBiomeIcon, true), true);
    }

    private List<ResourceLocation> getBiomeTypes() {
        ArrayList defaultBiomeTypes;
        ArrayList biomeTypes = Lists.newArrayList();
        Optional biomeRegistry = RegistryAccess.m_206197_().m_6632_(Registry.f_122885_);
        if (biomeRegistry.isPresent() && !(defaultBiomeTypes = Lists.newArrayList((Iterable)((Registry)biomeRegistry.get()).m_6566_())).isEmpty()) {
            for (ResourceLocation type : defaultBiomeTypes) {
                if (type == null) continue;
                biomeTypes.add(type);
            }
        }
        return biomeTypes;
    }

    public void getBiomes() {
        for (ResourceLocation TYPE : this.getBiomeTypes()) {
            if (TYPE == null) continue;
            if (!this.BIOME_NAMES.contains(StringUtils.formatIdentifier(TYPE.toString(), true, !CraftPresence.CONFIG.formatWords))) {
                this.BIOME_NAMES.add(StringUtils.formatIdentifier(TYPE.toString(), true, !CraftPresence.CONFIG.formatWords));
            }
            if (this.BIOME_TYPES.contains(TYPE)) continue;
            this.BIOME_TYPES.add(TYPE);
        }
        for (String biomeMessage : CraftPresence.CONFIG.biomeMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(biomeMessage) || StringUtils.isNullOrEmpty((part = biomeMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.BIOME_NAMES.contains(StringUtils.formatIdentifier(part[0], true, !CraftPresence.CONFIG.formatWords))) continue;
            this.BIOME_NAMES.add(StringUtils.formatIdentifier(part[0], true, !CraftPresence.CONFIG.formatWords));
        }
    }
}

