/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCore;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SocketImplShim;

class AFUNIXSocketImpl
extends SocketImplShim {
    private static final int SHUT_RD = 0;
    private static final int SHUT_WR = 1;
    private static final int SHUT_RD_WR = 2;
    private final AFUNIXSocketStreamCore core;
    final AncillaryDataSupport ancillaryDataSupport = new AncillaryDataSupport();
    private final AtomicBoolean bound = new AtomicBoolean(false);
    private Boolean createType = null;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private volatile boolean closedInputStream = false;
    private volatile boolean closedOutputStream = false;
    private final AFUNIXInputStream in = this.newInputStream();
    private final AFUNIXOutputStream out = this.newOutputStream();
    private boolean reuseAddr = true;
    private final AtomicInteger socketTimeout = new AtomicInteger(0);

    protected AFUNIXSocketImpl() throws SocketException {
        this(null);
    }

    protected AFUNIXSocketImpl(FileDescriptor fdObj) throws SocketException {
        this.address = InetAddress.getLoopbackAddress();
        this.core = new AFUNIXSocketStreamCore(this, fdObj, this.ancillaryDataSupport);
        this.fd = this.core.fd;
    }

    protected AFUNIXInputStream newInputStream() {
        return new AFUNIXInputStream();
    }

    protected AFUNIXOutputStream newOutputStream() {
        return new AFUNIXOutputStream();
    }

    FileDescriptor getFD() {
        return this.fd;
    }

    boolean isConnected() {
        if (this.connected.get()) {
            return true;
        }
        if (this.isClosed()) {
            return false;
        }
        if (this.core.isConnected(false)) {
            this.connected.set(true);
            return true;
        }
        return false;
    }

    boolean isBound() {
        if (this.bound.get()) {
            return true;
        }
        if (this.isClosed()) {
            return false;
        }
        if (this.core.isConnected(true)) {
            this.bound.set(true);
            return true;
        }
        return false;
    }

    AFUNIXSocketCore getCore() {
        return this.core;
    }

    private boolean isClosed() {
        return this.core.isClosed();
    }

    @Override
    protected void accept(SocketImpl socket) throws IOException {
        this.accept0(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean accept0(SocketImpl socket) throws IOException {
        AFUNIXSocketImpl si;
        AFUNIXSocketAddress socketAddress;
        block11: {
            FileDescriptor fdesc = this.core.validFdOrException();
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.isBound()) {
                throw new SocketException("Socket is not bound");
            }
            socketAddress = this.core.socketAddress;
            si = (AFUNIXSocketImpl)socket;
            try {
                this.core.incPendingAccepts();
                if (!NativeUnixSocket.accept(socketAddress.getBytes(), fdesc, si.fd, this.core.inode.get(), this.socketTimeout.get())) {
                    boolean bl = false;
                    return bl;
                }
                if (this.isBound() && !this.isClosed()) break block11;
                try {
                    NativeUnixSocket.shutdown(si.fd, 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    NativeUnixSocket.close(si.fd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SocketException("Socket is closed");
            }
            finally {
                this.core.decPendingAccepts();
            }
        }
        si.setSocketAddress(socketAddress);
        si.connected.set(true);
        return true;
    }

    void setSocketAddress(AFUNIXSocketAddress socketAddress) {
        if (socketAddress == null) {
            this.core.socketAddress = null;
            this.address = null;
            this.localport = -1;
        } else {
            this.core.socketAddress = socketAddress;
            this.address = socketAddress.getAddress();
            if (this.localport <= 0) {
                this.localport = socketAddress.getPort();
            }
        }
    }

    @Override
    protected int available() throws IOException {
        FileDescriptor fdesc = this.core.validFdOrException();
        return NativeUnixSocket.available(fdesc);
    }

    protected void bind(SocketAddress addr, int options) throws IOException {
        if (addr == null) {
            throw new IllegalArgumentException("Cannot bind to null address");
        }
        if (!(addr instanceof AFUNIXSocketAddress)) {
            throw new SocketException("Cannot bind to this type of address: " + addr.getClass());
        }
        this.bound.set(true);
        if (addr == AFUNIXSocketAddress.INTERNAL_DUMMY_BIND) {
            this.core.inode.set(0L);
            return;
        }
        AFUNIXSocketAddress socketAddress = (AFUNIXSocketAddress)addr;
        this.setSocketAddress(socketAddress);
        this.core.inode.set(NativeUnixSocket.bind(socketAddress.getBytes(), this.fd, options));
        this.core.validFdOrException();
    }

    @Override
    protected void bind(InetAddress host, int port) throws IOException {
    }

    private void checkClose() throws IOException {
        if (this.closedInputStream && this.closedOutputStream) {
            this.close();
        }
    }

    @Override
    protected final void close() throws IOException {
        this.core.runCleaner();
    }

    @Override
    protected void connect(String host, int port) throws IOException {
        throw new SocketException("Cannot bind to this type of address: " + InetAddress.class);
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        throw new SocketException("Cannot bind to this type of address: " + InetAddress.class);
    }

    @Override
    protected void connect(SocketAddress addr, int connectTimeout) throws IOException {
        this.connect0(addr, connectTimeout);
    }

    boolean connect0(SocketAddress addr, int connectTimeout) throws IOException {
        if (!(addr instanceof AFUNIXSocketAddress)) {
            throw new SocketException("Cannot bind to this type of address: " + addr.getClass());
        }
        if (addr == AFUNIXSocketAddress.INTERNAL_DUMMY_CONNECT) {
            this.connected.set(true);
            return true;
        }
        if (addr == AFUNIXSocketAddress.INTERNAL_DUMMY_CONNECT) {
            return false;
        }
        AFUNIXSocketAddress socketAddress = (AFUNIXSocketAddress)addr;
        boolean success = NativeUnixSocket.connect(socketAddress.getBytes(), this.fd, -1L);
        if (success) {
            this.setSocketAddress(socketAddress);
            this.connected.set(true);
        }
        this.core.validFdOrException();
        return success;
    }

    @Override
    protected void create(boolean stream) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Already closed");
        }
        if (this.fd.valid()) {
            if (this.createType != null) {
                if (this.createType != stream) {
                    throw new IllegalStateException("Already created with different mode");
                }
            } else {
                this.createType = stream;
            }
            return;
        }
        this.createType = stream;
        NativeUnixSocket.createSocket(this.fd, stream ? 1 : 2);
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (!this.isConnected() && !this.isBound()) {
            throw new IOException("Not connected/not bound");
        }
        this.core.validFdOrException();
        return this.in;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        if (!this.isClosed() && !this.isBound()) {
            throw new IOException("Not connected/not bound");
        }
        this.core.validFdOrException();
        return this.out;
    }

    @Override
    protected void listen(int backlog) throws IOException {
        FileDescriptor fdesc = this.core.validFdOrException();
        if (backlog <= 0) {
            backlog = 50;
        }
        NativeUnixSocket.listen(fdesc, backlog);
    }

    @Override
    protected boolean supportsUrgentData() {
        return false;
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static boolean checkWriteInterruptedException(int bytesTransferred) throws InterruptedIOException {
        if (Thread.interrupted()) {
            InterruptedIOException ex = new InterruptedIOException("Thread interrupted during write");
            ex.bytesTransferred = bytesTransferred;
            Thread.currentThread().interrupt();
            throw ex;
        }
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "[fd=" + this.fd + "; addr=" + this.core.socketAddress + "; connected=" + this.connected + "; bound=" + this.bound + "]";
    }

    private static int expectInteger(Object value) throws SocketException {
        try {
            return (Integer)value;
        }
        catch (ClassCastException e) {
            throw (SocketException)new SocketException("Unsupported value: " + value).initCause(e);
        }
        catch (NullPointerException e) {
            throw (SocketException)new SocketException("Value must not be null").initCause(e);
        }
    }

    private static int expectBoolean(Object value) throws SocketException {
        try {
            return (Boolean)value != false ? 1 : 0;
        }
        catch (ClassCastException e) {
            throw (SocketException)new SocketException("Unsupported value: " + value).initCause(e);
        }
        catch (NullPointerException e) {
            throw (SocketException)new SocketException("Value must not be null").initCause(e);
        }
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (optID == 4) {
            return this.reuseAddr;
        }
        FileDescriptor fdesc = this.core.validFdOrException();
        return AFUNIXSocketImpl.getOptionDefault(fdesc, optID, this.socketTimeout);
    }

    static Object getOptionDefault(FileDescriptor fdesc, int optID, AtomicInteger acceptTimeout) throws SocketException {
        try {
            switch (optID) {
                case 8: {
                    try {
                        return NativeUnixSocket.getSocketOptionInt(fdesc, optID) != 0;
                    }
                    catch (SocketException e) {
                        return false;
                    }
                }
                case 1: {
                    return NativeUnixSocket.getSocketOptionInt(fdesc, optID) != 0;
                }
                case 4102: {
                    return Math.max(acceptTimeout == null ? 0 : acceptTimeout.get(), Math.max(NativeUnixSocket.getSocketOptionInt(fdesc, 4101), NativeUnixSocket.getSocketOptionInt(fdesc, 4102)));
                }
                case 128: 
                case 4097: 
                case 4098: {
                    return NativeUnixSocket.getSocketOptionInt(fdesc, optID);
                }
                case 3: {
                    return 0;
                }
                case 15: {
                    return AFUNIXSocketAddress.getInetAddress(fdesc, false);
                }
                case 4: {
                    return false;
                }
            }
            throw new SocketException("Unsupported option: " + optID);
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SocketException)new SocketException("Could not get option").initCause(e);
        }
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (optID == 4) {
            this.reuseAddr = AFUNIXSocketImpl.expectBoolean(value) != 0;
            return;
        }
        FileDescriptor fdesc = this.core.validFdOrException();
        AFUNIXSocketImpl.setOptionDefault(fdesc, optID, value, this.socketTimeout);
    }

    static void setOptionDefault(FileDescriptor fdesc, int optID, Object value, AtomicInteger acceptTimeout) throws SocketException {
        try {
            switch (optID) {
                case 128: {
                    if (value instanceof Boolean) {
                        boolean b = (Boolean)value;
                        if (b) {
                            throw new SocketException("Only accepting Boolean.FALSE here");
                        }
                        NativeUnixSocket.setSocketOptionInt(fdesc, optID, -1);
                        return;
                    }
                    NativeUnixSocket.setSocketOptionInt(fdesc, optID, AFUNIXSocketImpl.expectInteger(value));
                    return;
                }
                case 4102: {
                    int timeout = AFUNIXSocketImpl.expectInteger(value);
                    NativeUnixSocket.setSocketOptionInt(fdesc, 4101, timeout);
                    NativeUnixSocket.setSocketOptionInt(fdesc, 4102, timeout);
                    if (acceptTimeout != null) {
                        acceptTimeout.set(timeout);
                    }
                    return;
                }
                case 4097: 
                case 4098: {
                    NativeUnixSocket.setSocketOptionInt(fdesc, optID, AFUNIXSocketImpl.expectInteger(value));
                    return;
                }
                case 8: {
                    try {
                        NativeUnixSocket.setSocketOptionInt(fdesc, optID, AFUNIXSocketImpl.expectBoolean(value));
                    }
                    catch (SocketException timeout) {
                        // empty catch block
                    }
                    return;
                }
                case 1: {
                    NativeUnixSocket.setSocketOptionInt(fdesc, optID, AFUNIXSocketImpl.expectBoolean(value));
                    return;
                }
                case 3: {
                    return;
                }
                case 4: {
                    return;
                }
            }
            throw new SocketException("Unsupported option: " + optID);
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SocketException)new SocketException("Error while setting option").initCause(e);
        }
    }

    @Override
    protected void shutdownInput() throws IOException {
        FileDescriptor fdesc = this.core.validFd();
        if (fdesc != null) {
            NativeUnixSocket.shutdown(fdesc, 0);
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        FileDescriptor fdesc = this.core.validFd();
        if (fdesc != null) {
            NativeUnixSocket.shutdown(fdesc, 1);
        }
    }

    AFUNIXSocketCredentials getPeerCredentials() throws IOException {
        return NativeUnixSocket.peerCredentials(this.fd, new AFUNIXSocketCredentials());
    }

    final FileDescriptor[] getReceivedFileDescriptors() {
        return this.ancillaryDataSupport.getReceivedFileDescriptors();
    }

    final void clearReceivedFileDescriptors() {
        this.ancillaryDataSupport.clearReceivedFileDescriptors();
    }

    final void receiveFileDescriptors(int[] fds) throws IOException {
        this.ancillaryDataSupport.receiveFileDescriptors(fds);
    }

    final void setOutboundFileDescriptors(FileDescriptor ... fdescs) throws IOException {
        this.ancillaryDataSupport.setOutboundFileDescriptors(fdescs);
    }

    final boolean hasOutboundFileDescriptors() {
        return this.ancillaryDataSupport.hasOutboundFileDescriptors();
    }

    int getAncillaryReceiveBufferSize() {
        return this.ancillaryDataSupport.getAncillaryReceiveBufferSize();
    }

    void setAncillaryReceiveBufferSize(int size) {
        this.ancillaryDataSupport.setAncillaryReceiveBufferSize(size);
    }

    void ensureAncillaryReceiveBufferSize(int minSize) {
        this.ancillaryDataSupport.ensureAncillaryReceiveBufferSize(minSize);
    }

    SocketAddress receive(ByteBuffer dst) throws IOException {
        return this.core.receive(dst);
    }

    int send(ByteBuffer src, SocketAddress target) throws IOException {
        return this.core.write(src, target, 0);
    }

    int read(ByteBuffer dst, ByteBuffer socketAddressBuffer) throws IOException {
        return this.core.read(dst, socketAddressBuffer, 0);
    }

    int write(ByteBuffer src) throws IOException {
        return this.core.write(src);
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        return this.core.fd;
    }

    void updatePorts(int local, int remote) {
        this.localport = local;
        if (remote >= 0) {
            this.port = remote;
        }
    }

    AFUNIXSocketAddress getLocalSocketAddress() {
        return AFUNIXSocketAddress.getSocketAddress(this.getFileDescriptor(), false, this.localport);
    }

    AFUNIXSocketAddress getRemoteSocketAddress() {
        return AFUNIXSocketAddress.getSocketAddress(this.getFileDescriptor(), true, this.port);
    }

    int getLocalPort1() {
        return this.localport;
    }

    int getRemotePort() {
        return this.port;
    }

    @Override
    protected InetAddress getInetAddress() {
        AFUNIXSocketAddress rsa = this.getRemoteSocketAddress();
        if (rsa == null) {
            return InetAddress.getLoopbackAddress();
        }
        return rsa.getInetAddress();
    }

    private final class AFUNIXInputStream
    extends InputStream {
        private volatile boolean streamClosed = false;
        private boolean eofReached = false;

        private AFUNIXInputStream() {
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.streamClosed) {
                throw new IOException("This InputStream has already been closed.");
            }
            FileDescriptor fdesc = AFUNIXSocketImpl.this.core.validFdOrException();
            if (len == 0) {
                return 0;
            }
            if (off < 0 || len < 0 || len > buf.length - off) {
                throw new IndexOutOfBoundsException();
            }
            return NativeUnixSocket.read(fdesc, buf, off, len, AFUNIXSocketImpl.this.ancillaryDataSupport, AFUNIXSocketImpl.this.socketTimeout.get());
        }

        @Override
        public int read() throws IOException {
            FileDescriptor fdesc = AFUNIXSocketImpl.this.core.validFdOrException();
            if (this.eofReached) {
                return -1;
            }
            int byteRead = NativeUnixSocket.read(fdesc, null, 0, 1, AFUNIXSocketImpl.this.ancillaryDataSupport, AFUNIXSocketImpl.this.socketTimeout.get());
            if (byteRead < 0) {
                this.eofReached = true;
                return -1;
            }
            return byteRead;
        }

        @Override
        public synchronized void close() throws IOException {
            this.streamClosed = true;
            FileDescriptor fdesc = AFUNIXSocketImpl.this.core.validFd();
            if (fdesc != null) {
                NativeUnixSocket.shutdown(fdesc, 0);
            }
            AFUNIXSocketImpl.this.closedInputStream = true;
            AFUNIXSocketImpl.this.checkClose();
        }

        @Override
        public int available() throws IOException {
            if (this.streamClosed) {
                throw new IOException("This InputStream has already been closed.");
            }
            return AFUNIXSocketImpl.this.available();
        }
    }

    private final class AFUNIXOutputStream
    extends OutputStream {
        private volatile boolean streamClosed = false;

        private AFUNIXOutputStream() {
        }

        @Override
        public void write(int oneByte) throws IOException {
            int written;
            FileDescriptor fdesc = AFUNIXSocketImpl.this.core.validFdOrException();
            while ((written = NativeUnixSocket.write(fdesc, null, oneByte, 1, AFUNIXSocketImpl.this.ancillaryDataSupport)) == 0 && AFUNIXSocketImpl.checkWriteInterruptedException(0)) {
            }
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            int written;
            if (this.streamClosed) {
                throw new SocketException("This OutputStream has already been closed.");
            }
            if (len < 0 || off < 0 || len > buf.length - off) {
                throw new IndexOutOfBoundsException();
            }
            FileDescriptor fdesc = AFUNIXSocketImpl.this.core.validFdOrException();
            if (len == 0) {
                return;
            }
            int writtenTotal = 0;
            do {
                if ((written = NativeUnixSocket.write(fdesc, buf, off, len, AFUNIXSocketImpl.this.ancillaryDataSupport)) < 0) {
                    throw new IOException("Unspecific error while writing");
                }
                off += written;
            } while ((len -= written) > 0 && AFUNIXSocketImpl.checkWriteInterruptedException(writtenTotal += written));
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.streamClosed) {
                return;
            }
            this.streamClosed = true;
            FileDescriptor fdesc = AFUNIXSocketImpl.this.core.validFd();
            if (fdesc != null) {
                NativeUnixSocket.shutdown(fdesc, 1);
            }
            AFUNIXSocketImpl.this.closedOutputStream = true;
            AFUNIXSocketImpl.this.checkClose();
        }
    }

    private static class AFUNIXSocketStreamCore
    extends AFUNIXSocketCore {
        private final AtomicInteger pendingAccepts = new AtomicInteger(0);

        private AFUNIXSocketStreamCore(AFUNIXSocketImpl observed, FileDescriptor fd, AncillaryDataSupport ancillaryDataSupport) {
            super(observed, fd, ancillaryDataSupport);
        }

        private void incPendingAccepts() throws SocketException {
            if (this.pendingAccepts.incrementAndGet() >= Integer.MAX_VALUE) {
                throw new SocketException("Too many pending accepts");
            }
        }

        private void decPendingAccepts() throws SocketException {
            this.pendingAccepts.decrementAndGet();
        }

        @Override
        protected void unblockAccepts() {
            if (this.socketAddress == null || this.socketAddress.getBytes() == null || this.inode.get() < 0L) {
                return;
            }
            while (this.pendingAccepts.get() > 0) {
                try {
                    FileDescriptor tmpFd = new FileDescriptor();
                    try {
                        NativeUnixSocket.createSocket(tmpFd, 1);
                        NativeUnixSocket.connect(this.socketAddress.getBytes(), tmpFd, this.inode.get());
                    }
                    catch (IOException e) {
                        return;
                    }
                    try {
                        NativeUnixSocket.shutdown(tmpFd, 2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        NativeUnixSocket.close(tmpFd);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    static final class Lenient
    extends AFUNIXSocketImpl {
        protected Lenient(FileDescriptor fdObj) throws SocketException {
            super(fdObj);
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
            try {
                super.setOption(optID, value);
            }
            catch (SocketException e) {
                switch (optID) {
                    case 1: {
                        return;
                    }
                }
                throw e;
            }
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            try {
                return super.getOption(optID);
            }
            catch (SocketException e) {
                switch (optID) {
                    case 1: 
                    case 8: {
                        return false;
                    }
                }
                throw e;
            }
        }
    }
}

