/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.CCubesCore;
import chanceCubes.util.CustomEntry;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.logging.log4j.Level;

public class HTTPUtil {
    public static final String API_URL = "https://api.theturkey.dev/";

    @SafeVarargs
    public static JsonElement makeAPIReq(String type, String url, CustomEntry<String, String> ... extras) throws Exception {
        return HTTPUtil.getWebFile(type, API_URL + url, extras);
    }

    @SafeVarargs
    public static JsonElement getWebFile(String type, String link, CustomEntry<String, String> ... extras) throws Exception {
        String line;
        int responseCode;
        HttpURLConnection con = (HttpURLConnection)new URL(link).openConnection();
        con.setDoInput(true);
        con.setReadTimeout(5000);
        con.setRequestProperty("Connection", "keep-alive");
        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:16.0) Gecko/20100101 Firefox/16.0");
        con.setRequestMethod(type);
        if (!type.equals("GET")) {
            con.setDoOutput(true);
            StringBuilder builder = new StringBuilder();
            for (CustomEntry<String, String> property : extras) {
                builder.append(property.getKey());
                builder.append("=");
                builder.append(property.getValue());
                builder.append("&");
            }
            if (builder.length() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            }
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(builder.toString());
            wr.flush();
            wr.close();
        }
        if ((responseCode = con.getResponseCode()) != 200) {
            CCubesCore.logger.log(Level.ERROR, "Update request returned response code: " + responseCode + " " + con.getResponseMessage());
            return JsonNull.INSTANCE;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuilder buffer = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        con.disconnect();
        return JsonParser.parseString((String)buffer.toString());
    }
}

