/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.UnaryOperator;

public class Codecs {
    public static <A> MapCodec<A> opt(String name, A defaultValue, Codec<A> codec) {
        return Codec.optionalField((String)name, codec).xmap(o -> o.orElse(defaultValue), a -> Optional.ofNullable(a));
    }

    public static <V> JsonElement encode(V v, Codec<V> codec) {
        return codec.encodeStart((DynamicOps)JsonOps.INSTANCE, v).result().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElse(null);
    }

    public static <V> V modify(V v, Codec<V> codec, UnaryOperator<JsonObject> modifier) {
        JsonElement json = Codecs.encode(v, codec);
        if (json == null) {
            return v;
        }
        JsonObject result = (JsonObject)modifier.apply(json.getAsJsonObject());
        return (V)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)result).result().map(Pair::getFirst).orElse(v);
    }
}

