/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data.gen;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraforged.mod.Environment;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.data.gen.EncodingException;
import com.terraforged.mod.registry.ModRegistries;
import com.terraforged.mod.util.FileUtil;
import com.terraforged.mod.util.Init;
import com.terraforged.mod.util.json.JsonFormatter;
import com.terraforged.mod.worldgen.GeneratorPreset;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;

public class DataGen
extends Init {
    public static final DataGen INSTANCE = new DataGen();

    @Override
    protected void doInit() {
        if (!Environment.DATA_GEN) {
            return;
        }
        DataGen.export(Paths.get("datagen", new String[0]));
    }

    public static void export(Path dir) {
        FileUtil.delete(dir);
        TerraForged.LOG.info("Generating json data");
        RegistryAccess.Writable registries = RegistryAccess.m_206197_();
        RegistryOps writeOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registries);
        DataGen.genGenerator(dir, (RegistryAccess)registries, (RegistryOps<JsonElement>)writeOps);
        DataGen.genBuiltin(dir, (RegistryAccess)registries, (RegistryOps<JsonElement>)writeOps);
        DataGen.genBiomes(dir, (RegistryAccess)registries, (RegistryOps<JsonElement>)writeOps);
    }

    private static void genGenerator(Path dir, RegistryAccess registries, RegistryOps<JsonElement> writeOps) {
        LevelStem generator = GeneratorPreset.getDefault(registries);
        JsonElement json = (JsonElement)LevelStem.f_63970_.encodeStart(writeOps, (Object)generator).resultOrPartial(System.err::println).orElseThrow();
        DataGen.export(dir, Registry.f_122819_, Level.f_46428_, json);
    }

    private static void genDimensionType(Path dir, RegistryAccess registries, RegistryOps<JsonElement> writeOps) {
        DataGen.export(dir, Registry.f_122818_, DimensionType.f_63843_, registries, writeOps);
    }

    private static void genBuiltin(Path dir, RegistryAccess registries, RegistryOps<JsonElement> writeOps) {
        for (ModRegistries.HolderEntry<?> holder : ModRegistries.getHolders()) {
            DataGen.export(dir, holder, registries, writeOps);
        }
    }

    private static void genBiomes(Path dir, RegistryAccess registries, RegistryOps<JsonElement> writeOps) {
        Registry biomes = registries.m_206191_(Registry.f_122885_);
        for (Map.Entry entry : biomes.m_6579_()) {
            if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("terraforged")) continue;
            JsonElement json = (JsonElement)Biome.f_47429_.encodeStart(writeOps, (Object)((Biome)entry.getValue())).result().orElseThrow();
            DataGen.export(dir, biomes.m_123023_(), (ResourceKey)entry.getKey(), json);
        }
    }

    private static <T> void export(Path dir, ModRegistries.HolderEntry<T> holder, RegistryAccess access, DynamicOps<JsonElement> ops) {
        DataGen.export(dir, holder.key(), holder.direct(), access, ops);
    }

    private static <T> void export(Path dir, ResourceKey<? extends Registry<T>> key, Codec<T> codec, RegistryAccess access, DynamicOps<JsonElement> ops) {
        Registry registry = access.m_206191_(key);
        DataGen.export(dir, registry, codec, ops);
    }

    private static <T> void export(Path dir, Registry<T> registry, Codec<T> codec, DynamicOps<JsonElement> ops) {
        TerraForged.LOG.info("Exporting registry: {}", (Object)registry.m_123023_());
        for (Map.Entry entry : registry.m_6579_()) {
            try {
                JsonElement json = (JsonElement)codec.encodeStart(ops, entry.getValue()).mapError(DataGen::logError).result().orElseThrow();
                DataGen.export(dir, registry.m_123023_(), (ResourceKey)entry.getKey(), json);
            }
            catch (Throwable t) {
                new EncodingException((ResourceKey)entry.getKey(), t).printStackTrace();
            }
        }
    }

    private static <T> void export(Path dir, ResourceKey<Registry<T>> registry, ResourceLocation name, Codec<T> codec, T value, DynamicOps<JsonElement> ops) {
        JsonElement json = (JsonElement)codec.encodeStart(ops, value).result().orElseThrow();
        Path file = dir.resolve("data").resolve(name.m_135827_()).resolve(registry.m_135782_().m_135815_()).resolve(name.m_135815_() + ".json");
        FileUtil.write(file, json, (writer, data) -> new JsonFormatter((Writer)writer).write((JsonElement)data));
    }

    private static void export(Path dir, ResourceKey<?> registry, ResourceKey<?> key, JsonElement json) {
        Path file = dir.resolve("data").resolve(key.m_135782_().m_135827_()).resolve(registry.m_135782_().m_135815_()).resolve(key.m_135782_().m_135815_() + ".json");
        Path parent = file.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            CompletableFuture.runAsync(() -> {
                try (BufferedWriter out = Files.newBufferedWriter(file, new OpenOption[0]);){
                    JsonFormatter.apply(json, out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    private static String logError(String s) {
        TerraForged.LOG.warn(s);
        return s;
    }
}

