/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.hooks;

import com.mojang.serialization.DataResult;
import com.terraforged.mod.hooks.RegistryAccessUtil;
import com.terraforged.mod.registry.ModRegistries;
import com.terraforged.mod.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public class BuiltinHook {
    private static final MethodHandle REGISTRY_GETTER = ReflectionUtil.field(RegistryAccess.WritableRegistryAccess.class, Map.class, new String[0]);

    public static <T> void load(RegistryAccess.Writable writable, RegistryOps<T> ops) {
        if (ops.m_206812_().isEmpty()) {
            return;
        }
        Map<ResourceKey<?>, Registry<?>> backing = BuiltinHook.getBacking(writable);
        for (ModRegistries.HolderEntry<?> holder : ModRegistries.getHolders()) {
            backing.put(holder.key(), (Registry<?>)RegistryAccessUtil.copy(holder.registry()));
        }
        for (ModRegistries.HolderEntry<?> holder : ModRegistries.getHolders()) {
            BuiltinHook.loadHolder(holder, ops);
        }
    }

    private static <T, E> void loadHolder(ModRegistries.HolderEntry<T> holder, RegistryOps<E> ops) {
        RegistryLoader.Bound loader = (RegistryLoader.Bound)ops.m_206812_().orElseThrow();
        DataResult result = loader.m_206789_(holder.key(), holder.direct(), ops.m_206831_());
        RegistryAccessUtil.printRegistryContents((Registry)result.result().orElseThrow());
    }

    private static Map<ResourceKey<?>, Registry<?>> getBacking(RegistryAccess.Writable writable) {
        try {
            return REGISTRY_GETTER.invokeExact((RegistryAccess.WritableRegistryAccess)writable);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Map.of();
        }
    }
}

