/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.noise.source.Line;
import com.terraforged.noise.util.NoiseUtil;
import java.awt.geom.Line2D;

public class MathUtil {
    public static final float EPSILON = 0.99999f;

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float map(float value, float min0, float max0, float min1, float max1) {
        float alpha = NoiseUtil.map(value, min0, max0, max0 - min0);
        return NoiseUtil.lerp(min1, max1, alpha);
    }

    public static int hash(int seed, int x) {
        return NoiseUtil.hash(seed, x);
    }

    public static int hash(int seed, int x, int z) {
        return NoiseUtil.hash2D(seed, x, z);
    }

    public static float getPosX(int hash, int cx, float jitter) {
        float offset = MathUtil.rand(hash, 1619);
        return (float)cx + offset * jitter;
    }

    public static float getPosY(int hash, int cy, float jitter) {
        float offset = MathUtil.rand(hash, 31337);
        return (float)cy + offset * jitter;
    }

    public static float getPosX(int hash, int cx, float ox, float jitter) {
        float offset = MathUtil.rand(hash, 1619);
        return (float)cx + ox + offset * jitter;
    }

    public static float getPosY(int hash, int cy, float oy, float jitter) {
        float offset = MathUtil.rand(hash, 31337);
        return (float)cy + oy + offset * jitter;
    }

    public static float randX(int hash) {
        return MathUtil.rand(hash, 1619);
    }

    public static float randZ(int hash) {
        return MathUtil.rand(hash, 31337);
    }

    public static float rand(int seed, int offset) {
        return MathUtil.rand(MathUtil.hash(seed, offset));
    }

    public static float rand(int seed, int x, int y) {
        return MathUtil.rand(MathUtil.hash(seed, x, y));
    }

    public static float rand(int n) {
        n ^= 0x653;
        float value = (float)((n ^= 0x7A69) * n * n * 60493) / 2.1474836E9f;
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    public static float sum(float[] values) {
        float sum = 0.0f;
        for (float value : values) {
            sum += value;
        }
        return sum;
    }

    protected static float getLineDistance(float x, float y, float ax, float ay, float bx, float by, float ar, float br) {
        float dx = bx - ax;
        float dy = by - ay;
        float v = (x - ax) * dx + (y - ay) * dy;
        v = (v /= dx * dx + dy * dy) < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
        float tx = ax + dx * v;
        float ty = ay + dy * v;
        float tr = ar + (br - ar) * v;
        float tr2 = tr * tr;
        float d2 = Line.dist2(x, y, tx, ty);
        return d2 < tr2 ? 1.0f - NoiseUtil.sqrt(d2) / tr : 0.0f;
    }

    public static long getIntersection(float x, float y, float ax, float ay, float bx, float by) {
        float dx = bx - ax;
        float dy = by - ay;
        float v = (x - ax) * dx + (y - ay) * dy;
        float px = ax + dx * (v /= dx * dx + dy * dy);
        float py = ay + dy * v;
        return PosUtil.packf(px, py);
    }

    public static long getIntersection(float ax, float ay, float bx, float by, float cx, float cy, float dx, float dy) {
        float a1 = by - ay;
        float b2 = cx - dx;
        float a2 = dy - cy;
        float b1 = ax - bx;
        float det = a1 * b2 - a2 * b1;
        if (det == 0.0f) {
            return Long.MAX_VALUE;
        }
        float c1 = a1 * ax + b1 * ay;
        float c2 = a2 * cx + b2 * cy;
        float x = (b2 * c1 - b1 * c2) / det;
        float y = (a1 * c2 - a2 * c1) / det;
        return PosUtil.packf(x, y);
    }

    public static boolean intersects(float ax, float ay, float bx, float by, float cx, float cy, float dx, float dy) {
        return Line2D.linesIntersect(ax, ay, bx, by, cx, cy, dx, dy);
    }
}

