/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.map;

import com.terraforged.mod.Environment;
import com.terraforged.mod.util.map.LongCache;
import com.terraforged.noise.util.NoiseUtil;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import java.util.Arrays;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.util.Mth;

public class LossyCache<T>
implements LongCache<T> {
    protected final long[] keys;
    protected final T[] values;
    protected final int mask;
    protected final Consumer<T> removalListener;

    private LossyCache(int capacity, IntFunction<T[]> constructor, Consumer<T> removalListener) {
        capacity = Mth.m_14125_((int)capacity);
        this.mask = capacity - 1;
        this.keys = new long[capacity];
        this.values = constructor.apply(capacity);
        this.removalListener = removalListener;
        Arrays.fill(this.keys, Long.MIN_VALUE);
    }

    @Override
    public T computeIfAbsent(long key, Long2ObjectFunction<T> function) {
        int hash = LossyCache.hash(key);
        int index = hash & this.mask;
        T value = this.values[index];
        if (this.keys[index] == key && value != null) {
            return value;
        }
        Object newValue = function.apply(key);
        this.keys[index] = key;
        this.values[index] = newValue;
        this.onRemove(value);
        return (T)newValue;
    }

    protected void onRemove(T value) {
        if (value != null) {
            this.removalListener.accept(value);
        }
    }

    protected static int hash(long l) {
        return (int)HashCommon.mix((long)l);
    }

    public static <T> LongCache<T> of(int capacity, IntFunction<T[]> constructor) {
        return LossyCache.of(capacity, constructor, t -> {});
    }

    public static <T> LongCache<T> of(int capacity, IntFunction<T[]> constructor, Consumer<T> removalListener) {
        return new LossyCache<T>(capacity, constructor, removalListener);
    }

    public static <T> LongCache<T> concurrent(int capacity, IntFunction<T[]> constructor) {
        return LossyCache.concurrent(capacity, constructor, t -> {});
    }

    public static <T> LongCache<T> concurrent(int capacity, IntFunction<T[]> constructor, Consumer<T> removalListener) {
        return LossyCache.concurrent(capacity, Environment.CORES, constructor, removalListener);
    }

    public static <T> LongCache<T> concurrent(int capacity, int concurrency, IntFunction<T[]> constructor, Consumer<T> removalListener) {
        return new Concurrent<T>(capacity, concurrency, constructor, removalListener);
    }

    public static class Concurrent<T>
    implements LongCache<T> {
        protected static final int HASH_BITS = Integer.MAX_VALUE;
        protected final int mask;
        protected final Stamped<T>[] buckets;

        public Concurrent(int capacity, int concurrency, IntFunction<T[]> constructor, Consumer<T> removalListener) {
            concurrency = Mth.m_14125_((int)concurrency);
            capacity = NoiseUtil.floor((float)capacity / (float)concurrency);
            this.mask = concurrency - 1;
            this.buckets = new Stamped[concurrency];
            for (int i = 0; i < concurrency; ++i) {
                this.buckets[i] = new Stamped<T>(capacity, constructor, removalListener);
            }
        }

        @Override
        public T computeIfAbsent(long key, Long2ObjectFunction<T> function) {
            return this.buckets[this.index(key)].computeIfAbsent(key, function);
        }

        protected int index(long key) {
            return Concurrent.spread(key) & this.mask;
        }

        protected static int spread(long h) {
            return (int)(h ^ h >>> 16) & Integer.MAX_VALUE;
        }
    }

    public static class Stamped<T>
    extends LossyCache<T> {
        protected final StampedLock lock = new StampedLock();

        public Stamped(int capacity, IntFunction<T[]> constructor, Consumer<T> removalListener) {
            super(capacity, constructor, removalListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T computeIfAbsent(long key, Long2ObjectFunction<T> function) {
            int hash = Stamped.hash(key);
            int index = hash & this.mask;
            long optStamp = this.lock.tryOptimisticRead();
            long currentKey = this.keys[index];
            Object currentValue = this.values[index];
            if (!this.lock.validate(optStamp)) {
                long read = this.lock.readLock();
                try {
                    currentKey = this.keys[index];
                    currentValue = this.values[index];
                }
                finally {
                    this.lock.unlockRead(read);
                }
            }
            if (currentKey == key && currentValue != null) {
                return (T)currentValue;
            }
            return (T)this.write(key, index, currentValue, function);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected T write(long key, int index, T currentValue, Long2ObjectFunction<T> function) {
            long write = this.lock.writeLock();
            try {
                Object newValue = function.apply(key);
                this.keys[index] = key;
                this.values[index] = newValue;
                Object object = newValue;
                return (T)object;
            }
            finally {
                this.lock.unlockWrite(write);
                this.onRemove(currentValue);
            }
        }
    }
}

