/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraforged.mod.codec.WorldGenCodec;
import com.terraforged.mod.worldgen.GeneratorPreset;
import com.terraforged.mod.worldgen.GeneratorResource;
import com.terraforged.mod.worldgen.IGenerator;
import com.terraforged.mod.worldgen.VanillaGen;
import com.terraforged.mod.worldgen.biome.BiomeGenerator;
import com.terraforged.mod.worldgen.biome.Source;
import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import com.terraforged.mod.worldgen.noise.NoiseSample;
import com.terraforged.mod.worldgen.noise.climate.ClimateSample;
import com.terraforged.mod.worldgen.terrain.TerrainCache;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.mod.worldgen.terrain.TerrainLevels;
import com.terraforged.mod.worldgen.util.ChunkUtil;
import com.terraforged.mod.worldgen.util.ThreadPool;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.jetbrains.annotations.Nullable;

public class Generator
extends ChunkGenerator
implements IGenerator {
    public static final Codec<Generator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(g -> g.seed), (App)TerrainLevels.CODEC.optionalFieldOf("levels", (Object)TerrainLevels.DEFAULT.get()).forGetter(g -> g.levels), (App)WorldGenCodec.CODEC.forGetter(Generator::getRegistries)).apply((Applicative)instance, instance.stable(GeneratorPreset::build)));
    protected final long seed;
    protected final Source f_62137_;
    protected final TerrainLevels levels;
    protected final VanillaGen vanillaGen;
    protected final BiomeGenerator biomeGenerator;
    protected final INoiseGenerator noiseGenerator;
    protected final TerrainCache terrainCache;
    protected final ThreadLocal<GeneratorResource> localResource = ThreadLocal.withInitial(GeneratorResource::new);

    public Generator(long seed, TerrainLevels levels, VanillaGen vanillaGen, Source biomeSource, BiomeGenerator biomeGenerator, INoiseGenerator noiseGenerator) {
        super(vanillaGen.getStructureSets(), Optional.empty(), (BiomeSource)biomeSource, (BiomeSource)biomeSource, seed);
        this.seed = seed;
        this.levels = levels;
        this.vanillaGen = vanillaGen;
        this.f_62137_ = biomeSource;
        this.biomeGenerator = biomeGenerator;
        this.noiseGenerator = noiseGenerator;
        this.terrainCache = new TerrainCache(levels, noiseGenerator);
    }

    public long getSeed() {
        return this.seed;
    }

    protected RegistryAccess getRegistries() {
        return this.f_62137_.getRegistries();
    }

    public VanillaGen getVanillaGen() {
        return this.vanillaGen;
    }

    public INoiseGenerator getNoiseGenerator() {
        return this.noiseGenerator;
    }

    public TerrainData getChunkData(ChunkPos pos) {
        return this.terrainCache.getNow(pos);
    }

    public CompletableFuture<TerrainData> getChunkDataAsync(ChunkPos pos) {
        return this.terrainCache.getAsync(pos);
    }

    public Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public Generator withSeed(long seed) {
        INoiseGenerator noiseGenerator = this.noiseGenerator.with(seed, this.levels);
        Source biomeSource = new Source(seed, noiseGenerator, this.f_62137_);
        VanillaGen vanillaGen = new VanillaGen(seed, biomeSource, this.vanillaGen);
        BiomeGenerator biomeGenerator = new BiomeGenerator(seed, this.biomeGenerator);
        return new Generator(seed, this.levels, vanillaGen, biomeSource, biomeGenerator, noiseGenerator);
    }

    public int m_142062_() {
        return this.levels.minY;
    }

    public int m_6337_() {
        return this.levels.seaLevel;
    }

    public int m_6331_() {
        return this.levels.maxY;
    }

    public Source getBiomeSource() {
        return this.f_62137_;
    }

    public Climate.Sampler m_183403_() {
        return Source.NOOP_CLIMATE_SAMPLER;
    }

    @Nullable
    public Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> m_207970_(ServerLevel server, HolderSet<ConfiguredStructureFeature<?, ?>> feature, BlockPos pos, int i, boolean first) {
        return super.m_207970_(server, feature, pos, i, first);
    }

    public void m_62199_(RegistryAccess access, StructureFeatureManager structureFeatures, ChunkAccess chunk, StructureManager structures, long seed) {
        this.terrainCache.hint(chunk.m_7697_());
        super.m_62199_(access, structureFeatures, chunk, structures, seed);
    }

    public void m_62177_(WorldGenLevel level, StructureFeatureManager structureFeatures, ChunkAccess chunk) {
        this.terrainCache.hint(chunk.m_7697_());
        super.m_62177_(level, structureFeatures, chunk);
    }

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> registry, Executor executor, Blender blender, StructureFeatureManager structures, ChunkAccess chunk) {
        this.terrainCache.hint(chunk.m_7697_());
        return CompletableFuture.supplyAsync(() -> {
            ChunkUtil.fillNoiseBiomes(chunk, this.f_62137_, this.m_183403_(), this.localResource.get());
            return chunk;
        }, ThreadPool.EXECUTOR);
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureManager, ChunkAccess chunkAccess) {
        return this.terrainCache.combineAsync(executor, chunkAccess, (chunk, terrainData) -> {
            ChunkUtil.fillChunk(this.m_6337_(), chunk, terrainData, ChunkUtil.FILLER, this.localResource.get());
            ChunkUtil.primeHeightmaps(this.m_6337_(), chunk, terrainData, ChunkUtil.FILLER);
            ChunkUtil.buildStructureTerrain(chunk, terrainData, structureManager);
            return chunk;
        });
    }

    public void m_183621_(WorldGenRegion region, StructureFeatureManager structures, ChunkAccess chunk) {
        this.biomeGenerator.surface(chunk, region, this);
    }

    public void m_183516_(WorldGenRegion region, long seed, BiomeManager biomes, StructureFeatureManager structures, ChunkAccess chunk, GenerationStep.Carving stage) {
        this.biomeGenerator.carve(seed, chunk, region, biomes, stage, this);
    }

    public void m_183372_(WorldGenLevel region, ChunkAccess chunk, StructureFeatureManager structures) {
        this.biomeGenerator.decorate(chunk, region, structures, this);
        this.terrainCache.drop(chunk.m_7697_());
    }

    public void m_6929_(WorldGenRegion region) {
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)this.vanillaGen.getSettings().m_203334_();
        if (settings.f_64445_()) {
            return;
        }
        ChunkPos chunkPos = region.m_143488_();
        BlockPos position = chunkPos.m_45615_().m_175288_(region.m_151558_() - 1);
        Holder holder = region.m_204166_(position);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
        random.m_64690_(region.m_7328_(), chunkPos.m_45604_(), chunkPos.m_45605_());
        NaturalSpawner.m_204175_((ServerLevelAccessor)region, (Holder)holder, (ChunkPos)chunkPos, (Random)random);
    }

    public int m_142647_(int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor) {
        NoiseSample sample = this.terrainCache.getSample(x, z);
        float scaledBase = this.levels.getScaledBaseLevel(sample.baseNoise);
        float scaledHeight = this.levels.getScaledHeight(sample.heightNoise);
        int base = this.levels.getHeight(scaledBase);
        int height = this.levels.getHeight(scaledHeight);
        return switch (types) {
            default -> throw new IncompatibleClassChangeError();
            case Heightmap.Types.WORLD_SURFACE, Heightmap.Types.WORLD_SURFACE_WG, Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES -> Math.max(base, height) + 1;
            case Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.OCEAN_FLOOR_WG -> height + 1;
        };
    }

    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor levelHeightAccessor) {
        NoiseSample sample = this.terrainCache.getSample(x, z);
        float scaledBase = this.levels.getScaledBaseLevel(sample.baseNoise);
        float scaledHeight = this.levels.getScaledHeight(sample.heightNoise);
        int base = this.levels.getHeight(scaledBase);
        int height = this.levels.getHeight(scaledHeight);
        int surface = Math.max(base, height);
        Object[] states = new BlockState[surface];
        Arrays.fill(states, 0, height, Blocks.f_50069_.m_49966_());
        if (surface > height) {
            Arrays.fill(states, height, surface, Blocks.f_49990_.m_49966_());
        }
        return new NoiseColumn(height, (BlockState[])states);
    }

    public void m_207076_(List<String> lines, BlockPos pos) {
        ClimateSample sample = this.f_62137_.getBiomeSampler().getSample();
        this.terrainCache.sample(pos.m_123341_(), pos.m_123343_(), sample);
        this.f_62137_.getBiomeSampler().sample(pos.m_123341_(), pos.m_123343_(), sample);
        lines.add("");
        lines.add("[TerraForged]");
        lines.add("Terrain Type: " + sample.terrainType.getName());
        lines.add("Climate Type: " + sample.climateType.name());
        lines.add("Base Noise: " + sample.baseNoise);
        lines.add("Height Noise: " + sample.heightNoise);
        lines.add("Ocean Proximity: " + (1.0f - sample.continentNoise));
        lines.add("River Proximity: " + (1.0f - sample.riverNoise));
    }
}

