/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen;

import com.terraforged.mod.TerraForged;
import com.terraforged.mod.data.ModTerrains;
import com.terraforged.mod.util.TranslationUtil;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.VanillaGen;
import com.terraforged.mod.worldgen.asset.TerrainNoise;
import com.terraforged.mod.worldgen.biome.BiomeGenerator;
import com.terraforged.mod.worldgen.biome.Source;
import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import com.terraforged.mod.worldgen.noise.NoiseGenerator;
import com.terraforged.mod.worldgen.profiler.GeneratorProfiler;
import com.terraforged.mod.worldgen.terrain.TerrainLevels;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class GeneratorPreset {
    public static final ResourceLocation PRESET_NAME = TerraForged.location("preset");
    public static final String TRANSLATION_KEY = TranslationUtil.key("generator", PRESET_NAME);

    public static Generator build(long seed, TerrainLevels levels, RegistryAccess registries) {
        TerrainNoise[] terrain = ModTerrains.getTerrain(registries);
        BiomeGenerator biomeGenerator = new BiomeGenerator(seed, registries);
        INoiseGenerator noiseGenerator = new NoiseGenerator(seed, levels, terrain).withErosion();
        Source biomeSource = new Source(seed, noiseGenerator, registries);
        VanillaGen vanillaGen = GeneratorPreset.getVanillaGen(seed, biomeSource, registries);
        return new Generator(seed, levels, vanillaGen, biomeSource, biomeGenerator, noiseGenerator);
    }

    public static LevelStem getDefault(RegistryAccess registries) {
        Generator generator = GeneratorPreset.build(0L, TerrainLevels.DEFAULT.get().copy(), registries);
        Registry type = registries.m_206191_(Registry.f_122818_);
        return new LevelStem(type.m_206081_(DimensionType.f_63845_), (ChunkGenerator)generator);
    }

    public static VanillaGen getVanillaGen(long seed, BiomeSource biomes, RegistryAccess access) {
        Registry structures = access.m_206191_(Registry.f_211073_);
        Registry parameters = access.m_175515_(Registry.f_194568_);
        Holder settings = access.m_175515_(Registry.f_122878_).m_206081_(NoiseGeneratorSettings.f_64432_);
        return new VanillaGen(seed, biomes, (Holder<NoiseGeneratorSettings>)settings, (Registry<NormalNoise.NoiseParameters>)parameters, (Registry<StructureSet>)structures);
    }

    public static boolean isTerraForgedWorld(WorldGenSettings settings) {
        LevelStem stem = (LevelStem)settings.m_204655_().m_123013_(LevelStem.f_63971_);
        return GeneratorPreset.getGenerator(stem.m_63990_()) != null;
    }

    public static boolean isTerraForgedWorld(ServerLevel level) {
        return GeneratorPreset.getGenerator(level) != null;
    }

    public static Generator getGenerator(ServerLevel level) {
        return GeneratorPreset.getGenerator(level.m_7726_().m_8481_());
    }

    private static Generator getGenerator(ChunkGenerator chunkGenerator) {
        if (chunkGenerator instanceof GeneratorProfiler) {
            GeneratorProfiler profiler = (GeneratorProfiler)chunkGenerator;
            chunkGenerator = profiler.getGenerator();
        }
        if (chunkGenerator instanceof Generator) {
            Generator generator = (Generator)chunkGenerator;
            return generator;
        }
        return null;
    }
}

