/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.biomes;

import com.terraforged.mod.TerraForged;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public record ModBiome(ResourceKey<Biome> key, Supplier<Biome> factory) {
    public Biome create() {
        return this.factory.get();
    }

    public static ModBiome of(String name, ResourceKey<Biome> parent, Consumer<Biome.BiomeBuilder> modifier) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)TerraForged.location(name));
        Supplier<Biome> factory = ModBiome.copyFactory(parent, modifier);
        return new ModBiome((ResourceKey<Biome>)key, factory);
    }

    private static Supplier<Biome> copyFactory(ResourceKey<Biome> parent, Consumer<Biome.BiomeBuilder> modifier) {
        return () -> {
            Biome.BiomeBuilder builder = ModBiome.builderOf(parent);
            modifier.accept(builder);
            return builder.m_47592_();
        };
    }

    private static Biome.BiomeBuilder builderOf(ResourceKey<Biome> parent) {
        Biome biome = (Biome)BuiltinRegistries.f_123865_.m_123013_(parent);
        Holder holder = BuiltinRegistries.f_123865_.m_206081_(parent);
        Biome.BiomeBuilder builder = new Biome.BiomeBuilder();
        builder.m_47611_(biome.m_47548_());
        builder.m_47595_(Biome.m_204183_((Holder)holder));
        builder.m_47609_(biome.m_47554_());
        builder.m_47605_(biome.m_47518_());
        builder.m_47597_(biome.m_47530_());
        builder.m_47603_(biome.m_47557_());
        builder.m_47601_(biome.m_47536_());
        return builder;
    }
}

