/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.util;

import com.terraforged.engine.world.biome.type.BiomeType;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.registry.ModRegistry;
import com.terraforged.mod.util.map.WeightMap;
import com.terraforged.mod.worldgen.asset.ClimateType;
import com.terraforged.mod.worldgen.biome.util.BiomeUtil;
import it.unimi.dsi.fastutil.objects.Object2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeMapManager {
    private static final BiomeType[] TYPES = BiomeType.values();
    private static final BiomeTypeHolder[] HOLDERS = (BiomeTypeHolder[])Stream.of(TYPES).map(BiomeTypeHolder::new).toArray(BiomeTypeHolder[]::new);
    private final Registry<Biome> biomes;
    private final Registry<ClimateType> climateTypes;
    private final List<Holder<Biome>> overworldBiomes;
    private final Map<BiomeType, WeightMap<Holder<Biome>>> biomeMap;

    public BiomeMapManager(RegistryAccess access) {
        this.biomes = access.m_206191_(Registry.f_122885_);
        this.climateTypes = access.m_206191_((ResourceKey)ModRegistry.CLIMATE.get());
        this.overworldBiomes = BiomeMapManager.getOverworldBiomes(this.biomes, this.climateTypes);
        this.biomeMap = this.buildBiomeMap();
    }

    public Holder<Biome> get(ResourceKey<Biome> key) {
        return this.biomes.m_206081_(key);
    }

    public Registry<Biome> getBiomes() {
        return this.biomes;
    }

    public List<Holder<Biome>> getOverworldBiomes() {
        return this.overworldBiomes;
    }

    public Map<BiomeType, WeightMap<Holder<Biome>>> getBiomeMap() {
        return this.biomeMap;
    }

    private Map<BiomeType, WeightMap<Holder<Biome>>> buildBiomeMap() {
        Map<BiomeType, Object2FloatMap<Holder<Biome>>> map = this.getWeightsMap();
        EnumMap<BiomeType, WeightMap<Holder<Biome>>> result = new EnumMap<BiomeType, WeightMap<Holder<Biome>>>(BiomeType.class);
        for (Map.Entry<BiomeType, Object2FloatMap<Holder<Biome>>> entry : map.entrySet()) {
            Holder[] values = (Holder[])entry.getValue().keySet().toArray(Holder[]::new);
            float[] weights = entry.getValue().values().toFloatArray();
            result.put(entry.getKey(), new WeightMap<Holder>(values, weights));
        }
        return result;
    }

    private Map<BiomeType, Object2FloatMap<Holder<Biome>>> getWeightsMap() {
        HashMap<BiomeType, Object2FloatMap<Holder<Biome>>> map = new HashMap<BiomeType, Object2FloatMap<Holder<Biome>>>();
        ObjectOpenHashSet registered = new ObjectOpenHashSet();
        for (BiomeTypeHolder typeHolder : HOLDERS) {
            ClimateType biomeType = (ClimateType)this.climateTypes.m_7745_(typeHolder.name);
            if (biomeType == null) {
                map.put(typeHolder.type(), BiomeMapManager.newMutableWeightMap());
                continue;
            }
            Object2FloatMap<Holder<Biome>> typeMap = BiomeMapManager.getBiomeWeights(biomeType, this.biomes, arg_0 -> ((ObjectOpenHashSet)registered).add(arg_0));
            map.put(typeHolder.type(), typeMap);
        }
        for (Holder holder : this.overworldBiomes) {
            BiomeType type;
            if (registered.contains((Object)holder) || (type = BiomeUtil.getType((Holder<Biome>)holder)) == null) continue;
            map.computeIfAbsent(type, t -> new Object2FloatLinkedOpenHashMap()).put((Object)holder, 1.0f);
        }
        return map;
    }

    private static Object2FloatMap<Holder<Biome>> getBiomeWeights(ClimateType type, Registry<Biome> biomes, Consumer<Holder<Biome>> registered) {
        Object2FloatMap<Holder<Biome>> map = BiomeMapManager.newMutableWeightMap();
        for (Object2FloatMap.Entry entry : type.getWeights().object2FloatEntrySet()) {
            ResourceKey key = (ResourceKey)biomes.m_7854_((Object)((Biome)biomes.m_6612_((ResourceLocation)entry.getKey()).orElseThrow())).orElseThrow();
            Holder biome = biomes.m_206081_(key);
            map.put((Object)biome, entry.getFloatValue());
            registered.accept((Holder<Biome>)biome);
        }
        return map;
    }

    private static List<Holder<Biome>> getOverworldBiomes(Registry<Biome> biomes, Registry<ClimateType> biomeTypes) {
        List<Holder<Biome>> list = BiomeUtil.getOverworldBiomes(biomes);
        ObjectOpenHashSet added = new ObjectOpenHashSet(list);
        for (ClimateType type : biomeTypes) {
            for (ResourceLocation name : type.getWeights().keySet()) {
                ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)name);
                Holder biome = biomes.m_206081_(key);
                if (!added.add((Object)biome)) continue;
                list.add((Holder<Biome>)biome);
            }
        }
        list.sort(BiomeUtil.BIOME_SORTER);
        return list;
    }

    private static Object2FloatMap<Holder<Biome>> newMutableWeightMap() {
        return new Object2FloatLinkedOpenHashMap();
    }

    private record BiomeTypeHolder(BiomeType type, ResourceLocation name) {
        public BiomeTypeHolder(BiomeType type) {
            this(type, TerraForged.location(type.name().toLowerCase(Locale.ROOT)));
        }
    }
}

