/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.test;

import com.terraforged.mod.worldgen.test.Volcano;
import com.terraforged.mod.worldgen.test.VolcanoConfig;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class VolcanoFeature
extends Feature<VolcanoConfig> {
    protected final ThreadLocal<Volcano.Cache> localCache = ThreadLocal.withInitial(Volcano.Cache::new);

    public VolcanoFeature() {
        super(VolcanoConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<VolcanoConfig> context) {
        return true;
    }

    private static void fillColumn(int x, int z, int height, int surface, Volcano.Value value, VolcanoConfig config, ChunkAccess chunk, BlockState filler) {
        BlockState lava = VolcanoFeature.getFluid(value.hash);
        int fluidLevel = VolcanoFeature.getFluidLevel(value.hash, config);
        for (int y = height; y > surface; --y) {
            int index = chunk.m_151564_(y);
            LevelChunkSection section = chunk.m_183278_(index);
            BlockState block = filler.m_60795_() && y <= fluidLevel ? lava : filler;
            section.m_62991_(x, y & 0xF, z, block, false);
        }
    }

    private static int getFluidLevel(long hash, VolcanoConfig config) {
        double height = config.fluidLevel().get(Volcano.Noise.rand(hash, 33199));
        return Volcano.toHeightValue(height);
    }

    private static BlockState getFluid(long hash) {
        double noise = Volcano.Noise.rand(hash, 39761);
        return noise < 0.5 ? Blocks.f_49990_.m_49966_() : Blocks.f_49991_.m_49966_();
    }

    private static boolean test(int x, int z, FeaturePlaceContext<VolcanoConfig> context) {
        int y = context.m_159775_().m_142647_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)context.m_159774_());
        return y < 180;
    }
}

