/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.impl;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.JourneymapClient;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.impl.ClientEventManager;
import journeymap.client.api.impl.PluginWrapper;
import journeymap.client.api.util.PluginHelper;
import journeymap.client.api.util.UIState;
import journeymap.client.io.FileHandler;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.OverlayDrawStep;
import journeymap.client.task.multi.ApiImageTask;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;

@ParametersAreNonnullByDefault
public enum ClientAPI implements IClientAPI
{
    INSTANCE;

    private final Logger LOGGER = Journeymap.getLogger();
    private final List<OverlayDrawStep> lastDrawSteps = new ArrayList<OverlayDrawStep>();
    private HashMap<String, PluginWrapper> plugins = new HashMap();
    private ClientEventManager clientEventManager = new ClientEventManager(this.plugins.values());
    private boolean drawStepsUpdateNeeded = true;
    private Context.UI lastUi = Context.UI.Any;
    private Context.MapType lastMapType = Context.MapType.Any;
    private ResourceKey<Level> lastDimension = Level.f_46428_;
    private File addonDataPath;
    private UIState lastUiState;

    private ClientAPI() {
        this.log("built with JourneyMap API 1.8-SNAPSHOT");
    }

    @Override
    public UIState getUIState(Context.UI ui) {
        switch (ui) {
            case Minimap: {
                return MiniMap.uiState();
            }
            case Fullscreen: {
                return Fullscreen.uiState();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public File getDataPath(String modId) {
        if (this.addonDataPath == null || Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        return new File(this.addonDataPath, modId);
    }

    public void refreshDataPathCache(boolean flush) {
        this.addonDataPath = flush ? null : FileHandler.getAddonDataPath(Minecraft.m_91087_());
    }

    @Override
    public List<Waypoint> getAllWaypoints() {
        return WaypointStore.INSTANCE.getAll().stream().map(journeymap.client.waypoint.Waypoint::toModWaypoint).collect(Collectors.toList());
    }

    @Override
    public List<Waypoint> getAllWaypoints(ResourceKey<Level> dim) {
        return WaypointStore.INSTANCE.getAll().stream().filter(wp -> wp.getDimensions().contains(dim.m_135782_().toString())).map(journeymap.client.waypoint.Waypoint::toModWaypoint).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Waypoint getWaypoint(String modId, String displayId) {
        return this.getPlugin(modId).getWaypoint(displayId);
    }

    @Override
    public List<Waypoint> getWaypoints(String modId) {
        return this.getPlugin(modId).getWaypoints();
    }

    @Override
    public void subscribe(String modId, EnumSet<ClientEvent.Type> enumSet) {
        try {
            this.getPlugin(modId).subscribe(enumSet);
            this.clientEventManager.updateSubscribedTypes();
        }
        catch (Throwable t) {
            this.logError("Error subscribing: " + t, t);
        }
    }

    @Override
    public void show(Displayable displayable) {
        try {
            if (this.playerAccepts(displayable)) {
                this.getPlugin(displayable.getModId()).show(displayable);
                this.drawStepsUpdateNeeded = true;
            }
        }
        catch (Throwable t) {
            this.logError("Error showing displayable: " + displayable, t);
        }
    }

    @Override
    public void remove(Displayable displayable) {
        try {
            if (this.playerAccepts(displayable)) {
                this.getPlugin(displayable.getModId()).remove(displayable);
                this.drawStepsUpdateNeeded = true;
            }
        }
        catch (Throwable t) {
            this.logError("Error removing displayable: " + displayable, t);
        }
    }

    @Override
    public void removeAll(String modId, DisplayType displayType) {
        try {
            if (this.playerAccepts(modId, displayType)) {
                this.getPlugin(modId).removeAll(displayType);
                this.drawStepsUpdateNeeded = true;
            }
        }
        catch (Throwable t) {
            this.logError("Error removing all displayables: " + displayType, t);
        }
    }

    @Override
    public void removeAll(String modId) {
        try {
            for (DisplayType displayType : DisplayType.values()) {
                this.removeAll(modId, displayType);
                this.drawStepsUpdateNeeded = true;
            }
            this.getPlugin(modId).removeAll();
        }
        catch (Throwable t) {
            this.logError("Error removing all displayables for mod: " + modId, t);
        }
    }

    public void purge() {
        try {
            this.drawStepsUpdateNeeded = true;
            this.lastDrawSteps.clear();
            this.plugins.clear();
            this.clientEventManager.purge();
        }
        catch (Throwable t) {
            this.logError("Error purging: " + t, t);
        }
    }

    @Override
    public boolean exists(Displayable displayable) {
        try {
            if (this.playerAccepts(displayable)) {
                return this.getPlugin(displayable.getModId()).exists(displayable);
            }
        }
        catch (Throwable t) {
            this.logError("Error checking exists: " + displayable, t);
        }
        return false;
    }

    @Override
    public boolean playerAccepts(String modId, DisplayType displayType) {
        return true;
    }

    @Override
    public void requestMapTile(String modId, ResourceKey<Level> dimension, Context.MapType apiMapType, ChunkPos startChunk, ChunkPos endChunk, @Nullable Integer chunkY, int zoom, boolean showGrid, Consumer<BufferedImage> callback) {
        boolean validModId;
        this.log("requestMapTile");
        boolean honorRequest = true;
        File worldDir = FileHandler.getJMWorldDir(Minecraft.m_91087_());
        boolean bl = validModId = Objects.equals("jmitems", modId) || Objects.equals("skymap", modId);
        if (!validModId) {
            honorRequest = false;
            this.logError("requestMapTile not supported");
        } else if (worldDir == null || !worldDir.exists() || !worldDir.isDirectory()) {
            honorRequest = false;
            this.logError("world directory not found: " + worldDir);
        }
        try {
            if (honorRequest) {
                JourneymapClient.getInstance().queueOneOff(new ApiImageTask(modId, dimension, apiMapType, startChunk, endChunk, chunkY, zoom, showGrid, callback));
            } else {
                Minecraft.m_91087_().m_18689_(() -> callback.accept(null));
            }
        }
        catch (Exception e) {
            callback.accept(null);
        }
    }

    private boolean playerAccepts(Displayable displayable) {
        return this.playerAccepts(displayable.getModId(), displayable.getDisplayType());
    }

    public ClientEventManager getClientEventManager() {
        return this.clientEventManager;
    }

    public void getDrawSteps(List<? super OverlayDrawStep> list, UIState uiState) {
        if (this.drawStepsUpdateNeeded) {
            this.lastDrawSteps.clear();
            for (PluginWrapper pluginWrapper : this.plugins.values()) {
                pluginWrapper.getDrawSteps(this.lastDrawSteps, uiState);
            }
            this.lastDrawSteps.sort(Comparator.comparingInt(DrawStep::getDisplayOrder));
            this.drawStepsUpdateNeeded = false;
        }
        if (uiState.ui != this.lastUi || !uiState.dimension.equals(this.lastDimension) || uiState.mapType != this.lastMapType) {
            this.drawStepsUpdateNeeded = true;
            this.lastUi = uiState.ui;
            this.lastUiState = uiState;
            this.lastDimension = uiState.dimension;
            this.lastMapType = uiState.mapType;
        }
        list.addAll(this.lastDrawSteps);
    }

    @Override
    public void toggleDisplay(@Nullable ResourceKey<Level> dimension, Context.MapType mapType, Context.UI mapUI, boolean enable) {
        this.log(String.format("Toggled display in %s:%s:%s:%s", dimension, mapType, mapUI, enable));
    }

    @Override
    public void toggleWaypoints(@Nullable ResourceKey<Level> dimension, Context.MapType mapType, Context.UI mapUI, boolean enable) {
        this.log(String.format("Toggled waypoints in %s:%s:%s:%s", dimension, mapType, mapUI, enable));
    }

    @Override
    public boolean isDisplayEnabled(@Nullable ResourceKey<Level> dimension, Context.MapType mapType, Context.UI mapUI) {
        return false;
    }

    @Override
    public boolean isWaypointsEnabled(@Nullable ResourceKey<Level> dimension, Context.MapType mapType, Context.UI mapUI) {
        return false;
    }

    private PluginWrapper getPlugin(String modId) {
        if (Strings.isEmpty((CharSequence)modId)) {
            throw new IllegalArgumentException("Invalid modId: " + modId);
        }
        PluginWrapper pluginWrapper = this.plugins.get(modId);
        if (pluginWrapper == null) {
            IClientPlugin plugin = PluginHelper.INSTANCE.getPlugins().get(modId);
            if (plugin == null) {
                if (modId.equals("journeymap")) {
                    plugin = new IClientPlugin(){

                        @Override
                        public void initialize(IClientAPI jmClientApi) {
                        }

                        @Override
                        public String getModId() {
                            return "journeymap";
                        }

                        @Override
                        public void onEvent(ClientEvent event) {
                        }
                    };
                } else {
                    throw new IllegalArgumentException("No plugin found for modId: " + modId);
                }
            }
            pluginWrapper = new PluginWrapper(plugin);
            this.plugins.put(modId, pluginWrapper);
        }
        return pluginWrapper;
    }

    public boolean isDrawStepsUpdateNeeded() {
        return this.drawStepsUpdateNeeded;
    }

    void log(String message) {
        this.LOGGER.info(String.format("[%s] %s", this.getClass().getSimpleName(), message));
    }

    private void logError(String message) {
        this.LOGGER.error(String.format("[%s] %s", this.getClass().getSimpleName(), message));
    }

    void logError(String message, Throwable t) {
        this.LOGGER.error(String.format("[%s] %s", this.getClass().getSimpleName(), message), t);
    }

    public void flagOverlaysForRerender() {
        for (OverlayDrawStep overlayDrawStep : this.lastDrawSteps) {
            overlayDrawStep.getOverlay().flagForRerender();
        }
    }

    public UIState getLastUIState() {
        return this.lastUiState;
    }
}

