/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import com.google.common.base.Strings;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.waypoint.WaypointParser;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ChatEventHandler
implements EventHandlerManager.EventHandler {
    @SubscribeEvent
    public void invoke(ClientChatReceivedEvent event) {
        if (event.getMessage() != null) {
            try {
                String text = event.getMessage().getString();
                if (!Strings.isNullOrEmpty((String)text)) {
                    WaypointParser.parseChatForWaypoints(event, text);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Unexpected exception on ClientChatReceivedEvent: " + LogFormatter.toString(e));
            }
        }
    }

    @SubscribeEvent
    public void onChatEvent(ClientChatEvent event) {
        String message = event.getMessage();
        if (message.regionMatches(0, "/jm", 0, 3)) {
            if (message.length() > 3) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                message = message.substring(4);
                EventHandlerManager.clientCommandInvoker.execute((CommandSource)player, message.split(" "));
            } else {
                String commands = EventHandlerManager.clientCommandInvoker.getPossibleCommands();
                String text = "Available sub commands are: " + commands;
                Minecraft.m_91087_().f_91074_.m_6352_((Component)new TextComponent(text), Util.f_137441_);
            }
            event.setCanceled(true);
        }
    }
}

