/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.events;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.PlayerData;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import journeymap.common.util.PermissionsManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PermissionsChangedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ForgeEvents {
    private static int playerUpdateTicks = 5;

    @SubscribeEvent
    public void onPermissionChangedEvent(PermissionsChangedEvent event) {
        if (event.getEntity() instanceof ServerPlayer && event.getNewLevel() != event.getOldLevel()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            MinecraftServer server = player.f_8924_;
            GameProfile profile = player.m_36316_();
            ServerOpList ops = server.m_6846_().m_11307_();
            if (event.getNewLevel() >= server.m_7022_()) {
                ops.m_11381_((StoredUserEntry)new ServerOpListEntry(profile, server.m_7022_(), ops.m_11351_(profile)));
            } else if (event.getNewLevel() == 0) {
                ops.m_11393_((Object)profile);
            }
            this.sendConfigsToPlayer(player);
        }
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (((ServerOption)PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadar.get()).enabled() && ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().size() > 1) {
            playerUpdateTicks = PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadarUpdateTime.get();
            ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
            if (world != null && world.m_46468_() % (long)playerUpdateTicks == 0L) {
                this.sendPlayersOnRadarToPlayers();
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.sendConfigsToPlayer((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            this.sendConfigsToPlayer((ServerPlayer)event.getPlayer());
            PlayerData.getPlayerData().getPlayer((ServerPlayer)event.getPlayer());
        }
    }

    private void sendConfigsToPlayer(ServerPlayer player) {
        PermissionsManager.getInstance().sendPermissions(player);
    }

    private void sendPlayersOnRadarToPlayers() {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        ServerOption option = (ServerOption)prop.worldPlayerRadar.get();
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            boolean playerRadarEnabled = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension((Entity)player)).playerRadarEnabled.get();
            boolean receiverOp = Journeymap.isOp((Player)player);
            if ((!option.enabled() || !playerRadarEnabled) && (!option.canOps() || !receiverOp)) continue;
            try {
                this.sendPlayerTrackingData(player, receiverOp);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private void sendPlayerTrackingData(ServerPlayer entityPlayerMP, boolean receiverOp) {
        ArrayList serverPlayers = new ArrayList(ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_());
        if (serverPlayers != null && serverPlayers.size() > 1) {
            GlobalProperties properties = PropertiesManager.getInstance().getGlobalProperties();
            for (ServerPlayer radarPlayer : serverPlayers) {
                boolean sameDimension = entityPlayerMP.f_19853_.m_46472_().equals((Object)radarPlayer.f_19853_.m_46472_());
                boolean sneaking = radarPlayer.m_6144_();
                boolean invisible = radarPlayer.m_20177_((Player)entityPlayerMP);
                boolean hideOp = properties.hideOps.get();
                boolean hideSpectators = properties.hideSpectators.get() != false && radarPlayer.m_5833_();
                boolean seeUnderground = this.seeUnderground(radarPlayer, receiverOp);
                boolean visible = sameDimension && (receiverOp && seeUnderground || !hideOp && !sneaking && !hideSpectators && !invisible && seeUnderground);
                visible = visible && this.isSelfHidden(radarPlayer, properties, receiverOp);
                UUID playerId = radarPlayer.m_142081_();
                if (entityPlayerMP.m_142081_().equals(playerId)) continue;
                Journeymap.getInstance().getDispatcher().sendPlayerLocationPacket(entityPlayerMP, radarPlayer, visible);
            }
        }
    }

    private boolean isSelfHidden(ServerPlayer radarPlayer, GlobalProperties properties, boolean receiverOp) {
        if (((ServerOption)properties.allowMultiplayerSettings.get()).hasOption(receiverOp) || ServerOption.OPS.equals(properties.allowMultiplayerSettings.get())) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(radarPlayer);
            boolean hiddenUnderground = player.isHiddenUnderground() && this.isUnderground(radarPlayer) && !Level.f_46429_.equals((Object)radarPlayer.f_19853_.m_46472_());
            return receiverOp || player.isVisible() && !hiddenUnderground;
        }
        return true;
    }

    private boolean seeUnderground(ServerPlayer player, boolean isOp) {
        ServerOption seeUnderground = (ServerOption)PropertiesManager.getInstance().getGlobalProperties().seeUndergroundPlayers.get();
        if (!Level.f_46429_.equals((Object)player.f_19853_.m_46472_()) && !ServerOption.ALL.equals(seeUnderground) && this.isUnderground(player)) {
            return seeUnderground.hasOption(isOp);
        }
        return true;
    }

    private boolean isUnderground(ServerPlayer player) {
        BlockPos headPos = player.m_146901_();
        return !player.m_183503_().m_45527_(headPos);
    }
}

