/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import journeymap.client.JourneymapClient;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionDataStorageHandler;
import journeymap.common.nbt.cache.CacheStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public class RegionData {
    private static final String BIOME_TAG_NAME = "biome_name";
    private static final String BLOCK_TAG_NAME = "block";
    private static final String TOP_Y_TAG_NAME = "top_y";
    private static final String BLOCK_COLOR_TAG_NAME = "block_color_";
    protected final RegionCoord regionCoord;
    protected final MapType mapType;
    protected boolean enabled;
    protected boolean loaded = false;
    protected final RegionDataStorageHandler.Key key;
    private final CacheStorage storage;

    public RegionData(RegionDataStorageHandler.Key key, CacheStorage storage) {
        this.regionCoord = key.rCoord;
        this.mapType = key.mapType;
        this.key = key;
        this.storage = storage;
        this.enabled = JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get();
    }

    public Biome getBiome(BlockPos blockPos) {
        CompoundTag blockData;
        if (this.enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(BIOME_TAG_NAME)) {
            String biomeName = blockData.m_128461_(BIOME_TAG_NAME);
            return BiomeHelper.getBiomeFromResourceString(biomeName);
        }
        return null;
    }

    public Integer getTopY(BlockPos blockPos) {
        CompoundTag blockData;
        if (this.enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(TOP_Y_TAG_NAME)) {
            return blockData.m_128451_(TOP_Y_TAG_NAME);
        }
        return blockPos.m_123342_();
    }

    public Integer getColor(BlockPos blockPos) {
        CompoundTag blockData;
        if (this.enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(BLOCK_COLOR_TAG_NAME)) {
            return blockData.m_128451_(BLOCK_COLOR_TAG_NAME);
        }
        return null;
    }

    public BlockState getBlockState(BlockPos blockPos) {
        CompoundTag blockData;
        if (this.enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(BLOCK_TAG_NAME)) {
            CompoundTag blockState = blockData.m_128469_(BLOCK_TAG_NAME);
            return NbtUtils.m_129241_((CompoundTag)blockState);
        }
        return null;
    }

    public void setBiome(CompoundTag blockData, Biome biome) {
        if (this.enabled) {
            String biomeName;
            String biomeString = BiomeHelper.getBiomeResource(biome).toString();
            if (blockData.m_128441_(BIOME_TAG_NAME) && (biomeName = blockData.m_128461_(BIOME_TAG_NAME)).equals(biomeString)) {
                return;
            }
            blockData.m_128359_(BIOME_TAG_NAME, biomeString);
        }
    }

    public void setBlockState(CompoundTag blockData, ChunkMD chunkMD, BlockPos pos) {
        if (this.enabled) {
            BlockMD blockMD = chunkMD.getBlockMD(pos.m_7494_());
            if (blockMD == null || blockMD.isIgnore()) {
                blockMD = chunkMD.getBlockMD(pos);
            }
            if (blockMD == null || blockMD.isIgnore()) {
                blockMD = chunkMD.getBlockMD(pos.m_7495_());
            }
            CompoundTag blockState = NbtUtils.m_129202_((BlockState)blockMD.getBlockState());
            blockData.m_128365_(BLOCK_TAG_NAME, (Tag)blockState);
        }
    }

    public void setY(CompoundTag blockData, int topY) {
        if (this.enabled) {
            int savedTopY;
            if (blockData.m_128441_(TOP_Y_TAG_NAME) && (savedTopY = blockData.m_128451_(TOP_Y_TAG_NAME)) == topY) {
                return;
            }
            blockData.m_128405_(TOP_Y_TAG_NAME, topY);
        }
    }

    public void setBlockColor(CompoundTag blockData, int color, MapType.Name mapTypeName) {
        if (this.enabled) {
            int savedColor;
            if (blockData.m_128441_(BLOCK_COLOR_TAG_NAME + mapTypeName.name()) && (savedColor = blockData.m_128451_(BLOCK_COLOR_TAG_NAME + mapTypeName.name())) == color) {
                return;
            }
            blockData.m_128405_(BLOCK_COLOR_TAG_NAME + mapTypeName.name(), color);
        }
    }

    public CompoundTag getBlockDataFromBlockPos(ChunkPos chunkPos, CompoundTag chunk, int x, int z) {
        if (this.enabled && chunk != null) {
            return this.getBlockDataForChunk(chunk, (chunkPos.f_45578_ << 4) + x, (chunkPos.f_45579_ << 4) + z);
        }
        return null;
    }

    private CompoundTag getBlockDataFromBlockPos(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        CompoundTag chunk = this.getChunkNbt(chunkPos);
        return this.getBlockDataForChunk(chunk, pos.m_123341_(), pos.m_123343_());
    }

    public CompoundTag getChunkNbt(ChunkPos chunkPos) {
        if (this.enabled) {
            CompoundTag chunkTag = this.storage.read(chunkPos);
            if (chunkTag == null) {
                chunkTag = new CompoundTag();
            }
            return chunkTag;
        }
        return null;
    }

    private CompoundTag getBlockDataForChunk(CompoundTag chunk, int x, int z) {
        if (chunk != null) {
            CompoundTag blockTag;
            String blockTagName = x + "," + z;
            if (chunk.m_128441_(blockTagName)) {
                blockTag = chunk.m_128469_(blockTagName);
            } else {
                blockTag = new CompoundTag();
                chunk.m_128365_(blockTagName, (Tag)blockTag);
            }
            return blockTag;
        }
        return null;
    }

    public void writeChunk(ChunkPos chunkPos, CompoundTag tag) {
        this.storage.write(chunkPos, tag);
    }
}

