/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Supplier;
import journeymap.common.Journeymap;
import journeymap.common.network.data.model.Location;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class TeleportPacket
implements Location {
    private double x;
    private double y;
    private double z;
    private String dim;

    public TeleportPacket() {
    }

    public TeleportPacket(double x, double y, double z, String dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public TeleportPacket(FriendlyByteBuf buf) {
        try {
            if (buf.capacity() > 1) {
                this.x = buf.readDouble();
                this.y = buf.readDouble();
                this.z = buf.readDouble();
                this.dim = buf.m_130136_(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for teleport packet: %s", t));
        }
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public String getDim() {
        return this.dim;
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.m_130070_(this.dim);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for teleport packet:" + t);
        }
    }

    public static void handle(TeleportPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Journeymap.getInstance().getPacketHandler().handleTeleportPacket(((NetworkEvent.Context)ctx.get()).getSender(), packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

