/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.registry.RegistryHelper;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.legacy.structure_gel.api.tags.GelStructureTags;
import com.legacy.structure_gel.core.SGAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureAccessHelper {
    public static boolean isLakeProof(StructureFeature<?> structure) {
        GelStructure gelStructure;
        if (structure instanceof GelStructure && (gelStructure = (GelStructure)structure).isLakeProof()) {
            return true;
        }
        return RegistryHelper.isInTag(Registry.f_122841_, GelStructureTags.LAKE_PROOF, structure);
    }

    public static boolean isInStructurePiece(ServerLevel serverLevel, StructureFeature<?> structure, BlockPos pos) {
        return ChunkGenerator.m_208044_((Registry)serverLevel.m_5962_().m_175515_(Registry.f_122882_), structure).anyMatch(configured -> serverLevel.m_8595_().m_207817_(pos, configured).m_73603_());
    }

    public static boolean isInStructure(ServerLevel serverLevel, StructureFeature<?> structure, BlockPos pos) {
        return ChunkGenerator.m_208044_((Registry)serverLevel.m_5962_().m_175515_(Registry.f_122882_), structure).anyMatch(configured -> serverLevel.m_8595_().m_207785_(pos, configured).m_73603_());
    }

    public static boolean hasFeatureChunkInRange(ChunkGenerator chunkGen, TagKey<ConfiguredStructureFeature<?, ?>> structureTag, RegistryAccess registryAccess, long levelSeed, ChunkPos chunkPos, int radius) {
        return StructureAccessHelper.hasFeatureChunkInRange(chunkGen, registryAccess.m_175515_(Registry.f_122882_).m_203561_(structureTag), levelSeed, chunkPos, radius);
    }

    public static boolean hasFeatureChunkInRange(ChunkGenerator chunkGen, HolderSet<ConfiguredStructureFeature<?, ?>> structures, long levelSeed, ChunkPos chunkPos, int radius) {
        for (Holder structure : structures) {
            if (!StructureAccessHelper.hasFeatureChunkInRange(chunkGen, structure, levelSeed, chunkPos, radius)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFeatureChunkInRange(ChunkGenerator chunkGen, Holder<ConfiguredStructureFeature<?, ?>> structure, long levelSeed, ChunkPos chunkPos, int radius) {
        int chunkX = chunkPos.f_45578_;
        int chunkZ = chunkPos.f_45579_;
        for (StructurePlacement placement : SGAccessor.CHUNK_GENERATOR_GET_PLACEMENTS.invoke(chunkGen, structure)) {
            for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
                for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                    if (!placement.m_212129_(chunkGen, levelSeed, x, z)) continue;
                    for (int dx = 0; dx < 2; ++dx) {
                        for (int dz = 0; dz < 2; ++dz) {
                            if (!((ConfiguredStructureFeature)structure.m_203334_()).m_209752_().m_203333_(chunkGen.m_203495_(QuartPos.m_175400_((int)((x - dx << 4) + 8)), QuartPos.m_175400_((int)70), QuartPos.m_175400_((int)((z - dz << 4) + 8))))) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

