/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;

public class GetBiomesCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"getbiomes").requires(source -> source.m_6761_(2));
        command.then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registry.f_122882_)).suggests(StructureGelCommand.STRUCTURES).executes(context -> GetBiomesCommand.getBiomes((CommandContext<CommandSourceStack>)context, StructureGelCommand.getResourceKeyHolder((CommandContext<CommandSourceStack>)context, Registry.f_122882_, "structure"))));
        return command;
    }

    private static int getBiomes(CommandContext<CommandSourceStack> context, Holder<ConfiguredStructureFeature<?, ?>> structure) {
        List<String> biomes = ((ConfiguredStructureFeature)structure.m_203334_()).m_209752_().m_203614_().map(Holder::m_203543_).filter(Optional::isPresent).map(o -> ((ResourceKey)o.get()).m_135782_().toString()).sorted().collect(Collectors.toList());
        Optional op = structure.m_203543_();
        ResourceLocation name = op.isPresent() ? ((ResourceKey)op.get()).m_135782_() : ((ConfiguredStructureFeature)structure.m_203334_()).f_65403_.getRegistryName();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (biomes.isEmpty()) {
            source.m_81354_((Component)new TextComponent(name + " has no biomes."), true);
        } else {
            source.m_81354_((Component)new TextComponent("[" + name + "]").m_130940_(ChatFormatting.GREEN), true);
            biomes.forEach(biomeName -> source.m_81354_((Component)new TextComponent(" - " + biomeName), true));
        }
        return biomes.size();
    }
}

