/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SaveStructuresCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"savestructures").requires(source -> source.m_6761_(2));
        command.then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> SaveStructuresCommand.saveStructuresBounds((CommandContext<CommandSourceStack>)context, BoundingBox.m_162375_((Vec3i)BlockPosArgument.m_118242_((CommandContext)context, (String)"from"), (Vec3i)BlockPosArgument.m_118242_((CommandContext)context, (String)"to"))))));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"search").executes(context -> SaveStructuresCommand.saveStructuresSearch((CommandContext<CommandSourceStack>)context, 32))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)128)).executes(context -> SaveStructuresCommand.saveStructuresSearch((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))));
        return command;
    }

    private static int saveStructuresBounds(CommandContext<CommandSourceStack> context, BoundingBox area) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        LinkedHashMap<BlockPos, StructureBlockEntity> structureBlocks = new LinkedHashMap<BlockPos, StructureBlockEntity>();
        for (BlockPos pos : BlockPos.m_121976_((int)area.m_162395_(), (int)area.m_162396_(), (int)area.m_162398_(), (int)area.m_162399_(), (int)area.m_162400_(), (int)area.m_162401_())) {
            StructureBlockEntity structureBlock;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof StructureBlockEntity) || (structureBlock = (StructureBlockEntity)blockEntity).m_59908_() != StructureMode.SAVE) continue;
            structureBlocks.put(pos, structureBlock);
        }
        return SaveStructuresCommand.save(context, structureBlocks);
    }

    private static int saveStructuresSearch(CommandContext<CommandSourceStack> context, int radius) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockPos pos = new BlockPos(((CommandSourceStack)context.getSource()).m_81371_());
        return SaveStructuresCommand.save(context, SaveStructuresCommand.findStructureBlocks(level, pos, new HashMap<BlockPos, StructureBlockEntity>(), radius));
    }

    private static Map<BlockPos, StructureBlockEntity> findStructureBlocks(ServerLevel level, BlockPos origin, Map<BlockPos, StructureBlockEntity> structureBlocks, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    StructureBlockEntity structureBlock;
                    BlockPos pos = origin.m_142082_(x, y, z);
                    BlockEntity blockEntity = level.m_7702_(pos);
                    if (!(blockEntity instanceof StructureBlockEntity) || (structureBlock = (StructureBlockEntity)blockEntity).m_59908_() != StructureMode.SAVE || structureBlocks.put(pos, structureBlock) != null) continue;
                    SaveStructuresCommand.findStructureBlocks(level, pos, structureBlocks, radius);
                }
            }
        }
        return structureBlocks;
    }

    private static int save(CommandContext<CommandSourceStack> context, Map<BlockPos, StructureBlockEntity> structureBlocks) {
        ArrayList<String> savedStructures = new ArrayList<String>();
        HashMap<BlockPos, String> duplicates = new HashMap<BlockPos, String>();
        for (Map.Entry<BlockPos, StructureBlockEntity> entry : structureBlocks.entrySet()) {
            StructureBlockEntity structureBlock = entry.getValue();
            if (!structureBlock.m_59901_() || !structureBlock.m_59830_()) continue;
            if (savedStructures.contains(structureBlock.m_59895_())) {
                duplicates.put(new BlockPos((Vec3i)entry.getKey()), structureBlock.m_59895_());
            }
            savedStructures.add(structureBlock.m_59895_());
        }
        if (savedStructures.size() > 0) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[Saved " + savedStructures.size() + " Structures]").m_130940_(ChatFormatting.GREEN), true);
            if (savedStructures.size() <= 50) {
                savedStructures.stream().sorted().forEach(structure -> ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(" - " + structure), true));
            } else {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(" - Too many structures to print. Check the console."), true);
                StructureGelMod.log("Saved structures:", new Object[0]);
                savedStructures.stream().sorted().forEach(x$0 -> StructureGelMod.log(x$0, new Object[0]));
            }
            if (duplicates.size() > 0) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Warning: Found " + duplicates.size() + " structures with a duplicate name. Click to teleport.").m_130940_(ChatFormatting.RED), true);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[Duplicate Structures]").m_130940_(ChatFormatting.RED), true);
                if (duplicates.size() <= 50) {
                    duplicates.forEach((pos, structure) -> ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(String.format("%s at (%d, %d, %d)", structure, pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_()))), true));
                } else {
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(" - Too many duplicates to print. Check the console."), true);
                    StructureGelMod.log("Duplicate structures:", new Object[0]);
                    duplicates.forEach((pos, structure) -> StructureGelMod.log(String.format("%s /tp @s %d %d %d", structure, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), new Object[0]));
                }
            }
            return savedStructures.size();
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("No structures were saved."), true);
        return 0;
    }
}

