/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.saw;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.actors.BlockBreakingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.saw.CuttingRecipe;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.components.saw.SawFilterSlot;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingInventory;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.recipe.RecipeConditions;
import com.simibubi.create.foundation.utility.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SawTileEntity
extends BlockBreakingKineticTileEntity {
    private static final Object cuttingRecipesKey = new Object();
    public static final Supplier<RecipeType<?>> woodcuttingRecipeType = Suppliers.memoize(() -> (RecipeType)Registry.f_122864_.m_7745_(new ResourceLocation("druidcraft", "woodcutting")));
    public ProcessingInventory inventory;
    private int recipeIndex;
    private final LazyOptional<IItemHandler> invProvider;
    private FilteringBehaviour filtering;
    private ItemStack playEvent;

    public SawTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ProcessingInventory(this::start).withSlotLimit((Boolean)AllConfigs.SERVER.recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.invProvider = LazyOptional.of(() -> this.inventory);
        this.playEvent = ItemStack.f_41583_;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour(this, new SawFilterSlot()).forRecipes();
        behaviours.add(this.filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnelsWhen(this::canProcess));
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("RecipeIndex", this.recipeIndex);
        super.write(compound, clientPacket);
        if (!clientPacket || this.playEvent.m_41619_()) {
            return;
        }
        compound.m_128365_("PlayEvent", (Tag)this.playEvent.serializeNBT());
        this.playEvent = ItemStack.f_41583_;
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.recipeIndex = compound.m_128451_("RecipeIndex");
        if (compound.m_128441_("PlayEvent")) {
            this.playEvent = ItemStack.m_41712_((CompoundTag)compound.m_128469_("PlayEvent"));
        }
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(0.125);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.m_41619_()) {
            boolean isWood = false;
            Item item = this.playEvent.m_41720_();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).m_40614_();
                isWood = block.getSoundType(block.m_49966_(), (LevelReader)this.f_58857_, this.f_58858_, null) == SoundType.f_56736_;
            }
            this.spawnEventParticles(this.playEvent);
            this.playEvent = ItemStack.f_41583_;
            if (!isWood) {
                AllSoundEvents.SAW_ACTIVATE_STONE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
            } else {
                AllSoundEvents.SAW_ACTIVATE_WOOD.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
            }
            return;
        }
    }

    @Override
    public void tick() {
        if (this.shouldRun() && this.ticksUntilNextProgress < 0) {
            this.destroyNextTick();
        }
        super.tick();
        if (!this.canProcess()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.isEmpty() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        float processingSpeed = Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnParticles(this.inventory.getStackInSlot(0));
        }
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                return;
            }
            this.playEvent = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        Vec3 itemMovement = this.getItemMovementVec();
        Direction itemMovementFacing = Direction.m_122366_((double)itemMovement.f_82479_, (double)itemMovement.f_82480_, (double)itemMovement.f_82481_);
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack tryExportingToBeltFunnel;
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.m_41619_() || (tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(stack, itemMovementFacing.m_122424_(), false)) == null) continue;
            if (tryExportingToBeltFunnel.m_41613_() != stack.m_41613_()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.m_41619_()) continue;
            return;
        }
        BlockPos nextPos = this.f_58858_.m_142022_(itemMovement.f_82479_, itemMovement.f_82480_, itemMovement.f_82481_);
        DirectBeltInputBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)this.f_58857_, nextPos, DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack remainder;
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.m_41619_() || (remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)).equals(stack, false)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.m_6596_();
                this.sendData();
            }
            return;
        }
        Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(itemMovement.m_82490_(0.5).m_82520_(0.0, 0.5, 0.0));
        Vec3 outMotion = itemMovement.m_82490_(0.0625).m_82520_(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            ItemEntity entityIn = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_, outPos.f_82481_, stack);
            entityIn.m_20256_(outMotion);
            this.f_58857_.m_7967_((Entity)entityIn);
        }
        this.inventory.clear();
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    @Override
    public void m_7651_() {
        this.invProvider.invalidate();
        super.m_7651_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != Direction.DOWN) {
            return this.invProvider.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void spawnEventParticles(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        Object particleData = null;
        particleData = stack.m_41720_() instanceof BlockItem ? new BlockParticleOption(ParticleTypes.f_123794_, ((BlockItem)stack.m_41720_()).m_40614_().m_49966_()) : new ItemParticleOption(ParticleTypes.f_123752_, stack);
        Random r = this.f_58857_.f_46441_;
        Vec3 v = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82520_(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            Vec3 m = VecHelper.offsetRandomly(new Vec3(0.0, 0.25, 0.0), r, 0.125f);
            this.f_58857_.m_7106_((ParticleOptions)particleData, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82480_);
        }
    }

    protected void spawnParticles(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        ItemParticleOption particleData = null;
        float speed = 1.0f;
        if (stack.m_41720_() instanceof BlockItem) {
            particleData = new BlockParticleOption(ParticleTypes.f_123794_, ((BlockItem)stack.m_41720_()).m_40614_().m_49966_());
        } else {
            particleData = new ItemParticleOption(ParticleTypes.f_123752_, stack);
            speed = 0.125f;
        }
        Random r = this.f_58857_.f_46441_;
        Vec3 vec = this.getItemMovementVec();
        Vec3 pos = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        float offset = this.inventory.recipeDuration != 0.0f ? this.inventory.remainingTime / this.inventory.recipeDuration : 0.0f;
        offset /= 2.0f;
        if (this.inventory.appliedRecipe) {
            offset -= 0.5f;
        }
        this.f_58857_.m_7106_((ParticleOptions)particleData, pos.m_7096_() + -vec.f_82479_ * (double)offset, pos.m_7098_() + (double)0.45f, pos.m_7094_() + -vec.f_82481_ * (double)offset, -vec.f_82479_ * (double)speed, (double)(r.nextFloat() * speed), -vec.f_82481_ * (double)speed);
    }

    public Vec3 getItemMovementVec() {
        boolean alongX = (Boolean)this.m_58900_().m_61143_((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new Vec3((double)(offset * (alongX ? 1 : 0)), 0.0, (double)(offset * (alongX ? 0 : -1)));
    }

    private void applyRecipe() {
        List<Recipe<?>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        Recipe<?> recipe = recipes.get(this.recipeIndex);
        int rolls = this.inventory.getStackInSlot(0).m_41613_();
        this.inventory.clear();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int roll = 0; roll < rolls; ++roll) {
            List<Object> results = new LinkedList();
            if (recipe instanceof CuttingRecipe) {
                results = ((CuttingRecipe)recipe).rollResults();
            } else if (recipe instanceof StonecutterRecipe || recipe.m_6671_() == woodcuttingRecipeType.get()) {
                results.add(recipe.m_8043_().m_41777_());
            }
            for (int i = 0; i < results.size(); ++i) {
                ItemStack stack = (ItemStack)results.get(i);
                ItemHelper.addToList(stack, list);
            }
        }
        for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
            this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
        }
    }

    private List<? extends Recipe<?>> getRecipes() {
        Optional<CuttingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(this.f_58857_, this.inventory.getStackInSlot(0), AllRecipeTypes.CUTTING.getType(), CuttingRecipe.class);
        if (assemblyRecipe.isPresent() && this.filtering.test(assemblyRecipe.get().m_8043_())) {
            return ImmutableList.of((Object)assemblyRecipe.get());
        }
        Predicate<Recipe<?>> types = RecipeConditions.isOfType(new RecipeType[]{AllRecipeTypes.CUTTING.getType(), (Boolean)AllConfigs.SERVER.recipes.allowStonecuttingOnSaw.get() != false ? RecipeType.f_44112_ : null, (Boolean)AllConfigs.SERVER.recipes.allowWoodcuttingOnSaw.get() != false ? woodcuttingRecipeType.get() : null});
        List<Recipe<?>> startedSearch = RecipeFinder.get(cuttingRecipesKey, this.f_58857_, types);
        return startedSearch.stream().filter(RecipeConditions.outputMatchesFilter(this.filtering)).filter(RecipeConditions.firstIngredientMatches(this.inventory.getStackInSlot(0))).filter(r -> !AllRecipeTypes.shouldIgnoreInAutomation(r)).collect(Collectors.toList());
    }

    public void insertItem(ItemEntity entity) {
        if (!this.canProcess()) {
            return;
        }
        if (!this.inventory.isEmpty()) {
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.inventory.clear();
        ItemStack remainder = this.inventory.insertItem(0, entity.m_32055_().m_41777_(), false);
        if (remainder.m_41619_()) {
            entity.m_146870_();
        } else {
            entity.m_32045_(remainder);
        }
    }

    public void start(ItemStack inserted) {
        Recipe<?> recipe;
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.isEmpty()) {
            return;
        }
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        List<Recipe<?>> recipes = this.getRecipes();
        boolean valid = !recipes.isEmpty();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        if ((recipe = recipes.get(this.recipeIndex)) instanceof CuttingRecipe) {
            time = ((CuttingRecipe)recipe).getProcessingDuration();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.m_41613_() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    protected boolean canProcess() {
        return this.m_58900_().m_61143_((Property)SawBlock.FACING) == Direction.UP;
    }

    @Override
    protected boolean shouldRun() {
        return ((Direction)this.m_58900_().m_61143_((Property)SawBlock.FACING)).m_122434_().m_122479_();
    }

    @Override
    protected BlockPos getBreakingPos() {
        return this.m_58899_().m_142300_((Direction)this.m_58900_().m_61143_((Property)SawBlock.FACING));
    }

    @Override
    public void onBlockBroken(BlockState stateToBreak) {
        Optional<AbstractBlockBreakQueue> dynamicTree = TreeCutter.findDynamicTree(stateToBreak.m_60734_(), this.breakingPos);
        if (dynamicTree.isPresent()) {
            dynamicTree.get().destroyBlocks(this.f_58857_, null, this::dropItemFromCutTree);
            return;
        }
        super.onBlockBroken(stateToBreak);
        TreeCutter.findTree((BlockGetter)this.f_58857_, this.breakingPos).destroyBlocks(this.f_58857_, null, this::dropItemFromCutTree);
    }

    public void dropItemFromCutTree(BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.m_123331_((Vec3i)this.breakingPos));
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(this.f_58857_, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, stack);
        entity.m_20256_(Vec3.m_82528_((Vec3i)this.breakingPos.m_141950_((Vec3i)this.f_58858_)).m_82490_((double)(distance / 20.0f)));
        this.f_58857_.m_7967_((Entity)entity);
    }

    @Override
    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        boolean sawable = SawTileEntity.isSawable(stateToBreak);
        return super.canBreak(stateToBreak, blockHardness) && sawable;
    }

    public static boolean isSawable(BlockState stateToBreak) {
        if (stateToBreak.m_204336_(BlockTags.f_13104_)) {
            return false;
        }
        if (stateToBreak.m_204336_(BlockTags.f_13106_) || AllTags.AllBlockTags.SLIMY_LOGS.matches(stateToBreak) || stateToBreak.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        Block block = stateToBreak.m_60734_();
        if (block instanceof BambooBlock) {
            return true;
        }
        if (block instanceof StemGrownBlock) {
            return true;
        }
        if (block instanceof CactusBlock) {
            return true;
        }
        if (block instanceof SugarCaneBlock) {
            return true;
        }
        if (block instanceof KelpPlantBlock) {
            return true;
        }
        if (block instanceof KelpBlock) {
            return true;
        }
        if (block instanceof ChorusPlantBlock) {
            return true;
        }
        return TreeCutter.canDynamicTreeCutFrom(block);
    }
}

