/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialGroup;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.instancing.ConditionalInstance;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Quaternion;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.GlueModel;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;

public class GlueInstance
extends EntityInstance<SuperGlueEntity>
implements TickableInstance {
    private static final ResourceLocation TEXTURE = Create.asResource("textures/entity/super_glue/slime.png");
    private final Quaternion rotation;
    protected ConditionalInstance<OrientedData> model;

    public GlueInstance(MaterialManager materialManager, SuperGlueEntity entity) {
        super(materialManager, (Entity)entity);
        Instancer<OrientedData> instancer = this.getInstancer(materialManager, entity);
        Direction face = entity.getFacingDirection();
        this.rotation = new Quaternion(AngleHelper.verticalAngle(face), AngleHelper.horizontalAngle(face), 0.0f, true);
        this.model = new ConditionalInstance(instancer).withCondition(this::shouldShow).withSetupFunc(this::positionModel).update();
    }

    private Instancer<OrientedData> getInstancer(MaterialManager materialManager, SuperGlueEntity entity) {
        MaterialGroup group = materialManager.cutout(RenderType.m_110452_((ResourceLocation)TEXTURE));
        return group.material(Materials.ORIENTED).model((Object)entity.m_6095_(), GlueModel::get);
    }

    public void tick() {
        this.model.update();
    }

    public void remove() {
        this.model.delete();
    }

    private void positionModel(OrientedData model) {
        model.setPosition(this.getInstancePosition()).setPivot(0.0f, 0.0f, 0.0f).setRotation(this.rotation);
        this.updateLight(model);
    }

    public void updateLight() {
        this.model.get().ifPresent(this::updateLight);
    }

    private void updateLight(OrientedData model) {
        BlockPos pos = ((SuperGlueEntity)this.entity).getHangingPosition();
        model.setBlockLight(this.world.m_45517_(LightLayer.BLOCK, pos)).setSkyLight(this.world.m_45517_(LightLayer.SKY, pos));
    }

    private boolean shouldShow() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return ((SuperGlueEntity)this.entity).isVisible() || AllItems.SUPER_GLUE.isIn(player.m_21205_()) || AllItems.SUPER_GLUE.isIn(player.m_21206_());
    }
}

