/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class AstralSorceryAttunementAttribute
implements ItemAttribute {
    String constellationName;

    public AstralSorceryAttunementAttribute(String constellationName) {
        this.constellationName = constellationName;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        CompoundTag nbt = this.extractAstralNBT(itemStack);
        String constellation = nbt.m_128441_("constellation") ? nbt.m_128461_("constellation") : nbt.m_128461_("constellationName");
        ResourceLocation itemResource = itemStack.m_41720_().getRegistryName();
        if (itemResource != null && itemResource.toString().contains("shifting_star_")) {
            constellation = itemResource.toString().replace("shifting_star_", "");
        }
        return constellation.equals(this.constellationName);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        CompoundTag nbt = this.extractAstralNBT(itemStack);
        String constellation = nbt.m_128441_("constellation") ? nbt.m_128461_("constellation") : nbt.m_128461_("constellationName");
        ResourceLocation itemResource = itemStack.m_41720_().getRegistryName();
        if (itemResource != null && itemResource.toString().contains("shifting_star_")) {
            constellation = itemResource.toString().replace("shifting_star_", "");
        }
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (constellation.length() > 0) {
            atts.add(new AstralSorceryAttunementAttribute(constellation));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        return "astralsorcery_constellation";
    }

    @Override
    public Object[] getTranslationParameters() {
        ResourceLocation constResource = new ResourceLocation(this.constellationName);
        String something = new TranslatableComponent(String.format("%s.constellation.%s", constResource.m_135827_(), constResource.m_135815_())).getString();
        return new Object[]{something};
    }

    @Override
    public void writeNBT(CompoundTag nbt) {
        nbt.m_128359_("constellation", this.constellationName);
    }

    @Override
    public ItemAttribute readNBT(CompoundTag nbt) {
        return new AstralSorceryAttunementAttribute(nbt.m_128461_("constellation"));
    }

    private CompoundTag extractAstralNBT(ItemStack stack) {
        return stack.m_41783_() != null ? stack.m_41783_().m_128469_("astralsorcery") : new CompoundTag();
    }
}

