/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.builders.BuilderCallback;
import com.simibubi.create.repack.registrate.builders.EntityBuilder;
import com.simibubi.create.repack.registrate.util.OneTimeEventReceiver;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@ParametersAreNonnullByDefault
public class CreateEntityBuilder<T extends Entity, P>
extends EntityBuilder<T, P> {
    @Nullable
    private NonNullSupplier<BiFunction<MaterialManager, T, EntityInstance<? super T>>> instanceFactory;
    private NonNullPredicate<T> renderNormally;

    public static <T extends Entity, P> EntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.EntityFactory<T> factory, MobCategory classification) {
        return new CreateEntityBuilder<T, P>(owner, parent, name, callback, factory, classification).defaultLang();
    }

    public CreateEntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.EntityFactory<T> factory, MobCategory classification) {
        super(owner, parent, name, callback, factory, classification);
    }

    public CreateEntityBuilder<T, P> instance(NonNullSupplier<BiFunction<MaterialManager, T, EntityInstance<? super T>>> instanceFactory) {
        return this.instance(instanceFactory, true);
    }

    public CreateEntityBuilder<T, P> instance(NonNullSupplier<BiFunction<MaterialManager, T, EntityInstance<? super T>>> instanceFactory, boolean renderNormally) {
        return this.instance(instanceFactory, be -> true);
    }

    public CreateEntityBuilder<T, P> instance(NonNullSupplier<BiFunction<MaterialManager, T, EntityInstance<? super T>>> instanceFactory, NonNullPredicate<T> renderNormally) {
        if (this.instanceFactory == null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerInstance);
        }
        this.instanceFactory = instanceFactory;
        this.renderNormally = renderNormally;
        return this;
    }

    protected void registerInstance() {
        OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, $ -> {
            NonNullSupplier<BiFunction<MaterialManager, T, EntityInstance<T>>> instanceFactory = this.instanceFactory;
            if (instanceFactory != null) {
                NonNullPredicate renderNormally = this.renderNormally;
                InstancedRenderRegistry.configure((EntityType)((EntityType)this.getEntry())).factory(instanceFactory.get()).skipRender(be -> !renderNormally.test(be)).apply();
            }
        });
    }
}

