/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class PonderChapter
implements ScreenElement {
    private final ResourceLocation id;
    private final ResourceLocation icon;

    private PonderChapter(ResourceLocation id) {
        this.id = id;
        this.icon = new ResourceLocation(id.m_135827_(), "textures/ponder/chapter/" + id.m_135815_() + ".png");
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getTitle() {
        return PonderLocalization.getChapter(this.id);
    }

    public PonderChapter addTagsToChapter(PonderTag ... tags) {
        for (PonderTag t : tags) {
            PonderRegistry.TAGS.add(t, this);
        }
        return this;
    }

    @Override
    public void render(PoseStack ms, int x, int y) {
        ms.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.icon);
        ms.m_85841_(0.25f, 0.25f, 1.0f);
        GuiComponent.m_93143_((PoseStack)ms, (int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        ms.m_85849_();
    }

    @Nonnull
    public static PonderChapter of(ResourceLocation id) {
        PonderChapter chapter = PonderRegistry.CHAPTERS.getChapter(id);
        if (chapter == null) {
            chapter = PonderRegistry.CHAPTERS.addChapter(new PonderChapter(id));
        }
        return chapter;
    }
}

