/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderChapterRegistry;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderTagRegistry;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.content.PonderIndex;
import com.simibubi.create.foundation.ponder.content.SharedText;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PonderRegistry {
    public static final PonderTagRegistry TAGS = new PonderTagRegistry();
    public static final PonderChapterRegistry CHAPTERS = new PonderChapterRegistry();
    public static final Map<ResourceLocation, List<PonderStoryBoardEntry>> ALL = new HashMap<ResourceLocation, List<PonderStoryBoardEntry>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStoryBoard(PonderStoryBoardEntry entry) {
        Map<ResourceLocation, List<PonderStoryBoardEntry>> map = ALL;
        synchronized (map) {
            List list;
            List list2 = list = ALL.computeIfAbsent(entry.getComponent(), $ -> new ArrayList());
            synchronized (list2) {
                list.add(entry);
            }
        }
    }

    public static List<PonderScene> compile(ResourceLocation id) {
        List<PonderStoryBoardEntry> list = ALL.get(id);
        if (list == null) {
            return Collections.emptyList();
        }
        return PonderRegistry.compile(list);
    }

    public static List<PonderScene> compile(PonderChapter chapter) {
        List<PonderStoryBoardEntry> list = CHAPTERS.getStories(chapter);
        if (list == null) {
            return Collections.emptyList();
        }
        return PonderRegistry.compile(list);
    }

    public static List<PonderScene> compile(List<PonderStoryBoardEntry> entries) {
        if (PonderIndex.editingModeActive()) {
            PonderLocalization.SHARED.clear();
            SharedText.gatherText();
        }
        ArrayList<PonderScene> scenes = new ArrayList<PonderScene>();
        for (int i = 0; i < entries.size(); ++i) {
            PonderStoryBoardEntry sb = entries.get(i);
            StructureTemplate activeTemplate = PonderRegistry.loadSchematic(sb.getSchematicLocation());
            PonderWorld world = new PonderWorld(BlockPos.f_121853_, (Level)Minecraft.m_91087_().f_91073_);
            activeTemplate.m_74536_((ServerLevelAccessor)world, BlockPos.f_121853_, BlockPos.f_121853_, new StructurePlaceSettings(), world.f_46441_, 2);
            world.createBackup();
            PonderScene scene = PonderRegistry.compileScene(i, sb, world);
            scene.begin();
            scenes.add(scene);
        }
        return scenes;
    }

    public static PonderScene compileScene(int i, PonderStoryBoardEntry sb, PonderWorld world) {
        PonderScene scene = new PonderScene(world, sb.getNamespace(), sb.getComponent(), sb.getTags());
        SceneBuilder builder = scene.builder();
        sb.getBoard().program(builder, scene.getSceneBuildingUtil());
        return scene;
    }

    public static StructureTemplate loadSchematic(ResourceLocation location) {
        return PonderRegistry.loadSchematic(Minecraft.m_91087_().m_91098_(), location);
    }

    public static StructureTemplate loadSchematic(ResourceManager resourceManager, ResourceLocation location) {
        block10: {
            StructureTemplate structureTemplate;
            block9: {
                String namespace = location.m_135827_();
                String path = "ponder/" + location.m_135815_() + ".nbt";
                ResourceLocation location1 = new ResourceLocation(namespace, path);
                Resource resource = resourceManager.m_142591_(location1);
                try {
                    structureTemplate = PonderRegistry.loadSchematic(resource.m_6679_());
                    if (resource == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (resource != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        Create.LOGGER.error("Ponder schematic missing: " + location1, (Throwable)e);
                        break block10;
                    }
                    catch (IOException e) {
                        Create.LOGGER.error("Failed to read ponder schematic: " + location1, (Throwable)e);
                    }
                }
                resource.close();
            }
            return structureTemplate;
        }
        return new StructureTemplate();
    }

    public static StructureTemplate loadSchematic(InputStream resourceStream) throws IOException {
        StructureTemplate t = new StructureTemplate();
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceStream)));
        CompoundTag nbt = NbtIo.m_128934_((DataInput)stream, (NbtAccounter)new NbtAccounter(0x20000000L));
        t.m_74638_(nbt);
        return t;
    }
}

