/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.sounds.SoundManager;
import net.minecraftforge.client.gui.GuiUtils;

public class PonderProgressBar
extends AbstractSimiWidget {
    LerpedFloat progress;
    PonderUI ponder;

    public PonderProgressBar(PonderUI ponder, int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.ponder = ponder;
        this.progress = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void tick() {
        this.progress.chase(this.ponder.getActiveScene().getSceneProgress(), 0.5, LerpedFloat.Chaser.EXP);
        this.progress.tickChaser();
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.f_93623_ && this.f_93624_ && this.ponder.getActiveScene().getKeyframeCount() > 0 && mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_ + 4) && mouseY >= (double)this.f_93621_ - 3.0 && mouseY < (double)(this.f_93621_ + this.f_93619_ + 20);
    }

    @Override
    public void m_5716_(double mouseX, double mouseY) {
        PonderScene activeScene = this.ponder.getActiveScene();
        int keyframeIndex = this.getHoveredKeyframeIndex(activeScene, mouseX);
        if (keyframeIndex == -1) {
            this.ponder.seekToTime(0);
        } else if (keyframeIndex == activeScene.getKeyframeCount()) {
            this.ponder.seekToTime(activeScene.getTotalTime());
        } else {
            this.ponder.seekToTime(activeScene.getKeyframeTime(keyframeIndex));
        }
    }

    public int getHoveredKeyframeIndex(PonderScene activeScene, double mouseX) {
        int keyframeTime;
        int totalTime = activeScene.getTotalTime();
        int clickedAtTime = (int)((mouseX - (double)this.f_93620_) / ((double)this.f_93618_ + 4.0) * (double)totalTime);
        int lastKeyframeTime = activeScene.getKeyframeTime(activeScene.getKeyframeCount() - 1);
        int diffToEnd = totalTime - clickedAtTime;
        int diffToLast = clickedAtTime - lastKeyframeTime;
        if (diffToEnd > 0 && diffToEnd < diffToLast / 2) {
            return activeScene.getKeyframeCount();
        }
        int index = -1;
        int i = 0;
        while (i < activeScene.getKeyframeCount() && (keyframeTime = activeScene.getKeyframeTime(i)) <= clickedAtTime) {
            index = i++;
        }
        return index;
    }

    @Override
    public void m_6303_(@Nonnull PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.f_93622_ = this.m_93680_(mouseX, mouseY);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(this.f_93620_, this.f_93621_, 300.0f)).withBounds(this.f_93618_, this.f_93619_)).render(ms);
        ms.m_85836_();
        ms.m_85837_((double)(this.f_93620_ - 2), (double)(this.f_93621_ - 2), 200.0);
        ms.m_85836_();
        ms.m_85841_((float)(this.f_93618_ + 4) * this.progress.getValue(partialTicks), 1.0f, 1.0f);
        int c1 = Theme.i(Theme.Key.PONDER_PROGRESSBAR, true);
        int c2 = Theme.i(Theme.Key.PONDER_PROGRESSBAR, false);
        GuiUtils.drawGradientRect((Matrix4f)ms.m_85850_().m_85861_(), (int)110, (int)0, (int)3, (int)1, (int)4, (int)c1, (int)c1);
        GuiUtils.drawGradientRect((Matrix4f)ms.m_85850_().m_85861_(), (int)110, (int)0, (int)4, (int)1, (int)5, (int)c2, (int)c2);
        ms.m_85849_();
        this.renderKeyframes(ms, mouseX, partialTicks);
        ms.m_85849_();
    }

    private void renderKeyframes(PoseStack ms, int mouseX, float partialTicks) {
        PonderScene activeScene = this.ponder.getActiveScene();
        int hoverStartColor = Theme.i(Theme.Key.PONDER_HOVER, true) | 0xA0000000;
        int hoverEndColor = Theme.i(Theme.Key.PONDER_HOVER, false) | 0xA0000000;
        int idleStartColor = Theme.i(Theme.Key.PONDER_IDLE, true) | 0x40000000;
        int idleEndColor = Theme.i(Theme.Key.PONDER_IDLE, false) | 0x40000000;
        int hoverIndex = this.f_93622_ ? this.getHoveredKeyframeIndex(activeScene, mouseX) : -2;
        if (hoverIndex == -1) {
            this.drawKeyframe(ms, activeScene, true, 0, 0, hoverStartColor, hoverEndColor, 8);
        } else if (hoverIndex == activeScene.getKeyframeCount()) {
            this.drawKeyframe(ms, activeScene, true, activeScene.getTotalTime(), this.f_93618_ + 4, hoverStartColor, hoverEndColor, 8);
        }
        for (int i = 0; i < activeScene.getKeyframeCount(); ++i) {
            int keyframeTime = activeScene.getKeyframeTime(i);
            int keyframePos = (int)((float)keyframeTime / (float)activeScene.getTotalTime() * (float)(this.f_93618_ + 4));
            boolean selected = i == hoverIndex;
            int startColor = selected ? hoverStartColor : idleStartColor;
            int endColor = selected ? hoverEndColor : idleEndColor;
            int height = selected ? 8 : 4;
            this.drawKeyframe(ms, activeScene, selected, keyframeTime, keyframePos, startColor, endColor, height);
        }
    }

    private void drawKeyframe(PoseStack ms, PonderScene activeScene, boolean selected, int keyframeTime, int keyframePos, int startColor, int endColor, int height) {
        if (selected) {
            int offset;
            String text;
            Font font = Minecraft.m_91087_().f_91062_;
            GuiUtils.drawGradientRect((Matrix4f)ms.m_85850_().m_85861_(), (int)100, (int)keyframePos, (int)10, (int)(keyframePos + 1), (int)(10 + height), (int)endColor, (int)startColor);
            ms.m_85836_();
            ms.m_85837_(0.0, 0.0, 100.0);
            if (activeScene.getCurrentTime() < keyframeTime) {
                text = ">";
                offset = -1 - font.m_92895_(text);
            } else {
                text = "<";
                offset = 3;
            }
            font.m_92883_(ms, text, (float)(keyframePos + offset), 10.0f, endColor);
            ms.m_85849_();
        }
        GuiUtils.drawGradientRect((Matrix4f)ms.m_85850_().m_85861_(), (int)500, (int)keyframePos, (int)-1, (int)(keyframePos + 1), (int)(2 + height), (int)startColor, (int)endColor);
    }

    public void m_7435_(SoundManager handler) {
    }
}

