/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class BottlingMachineRecipe
extends MultiblockRecipe {
    public static RecipeType<BottlingMachineRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<BottlingMachineRecipe>> SERIALIZER;
    public static final CachedRecipeList<BottlingMachineRecipe> RECIPES;
    public final Ingredient input;
    public final FluidTagInput fluidInput;
    public final Lazy<ItemStack> output;

    public BottlingMachineRecipe(ResourceLocation id, Lazy<ItemStack> output, Ingredient input, FluidTagInput fluidInput) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.fluidInput = fluidInput;
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.fluidInput});
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)this.output.get()}));
    }

    protected IERecipeSerializer<BottlingMachineRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static BottlingMachineRecipe findRecipe(Level level, ItemStack input, FluidStack fluid) {
        if (!input.m_41619_() && !fluid.isEmpty()) {
            for (BottlingMachineRecipe recipe : RECIPES.getRecipes(level)) {
                if (!recipe.input.test(input) || !recipe.fluidInput.test(fluid)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        RECIPES = new CachedRecipeList<BottlingMachineRecipe>(() -> TYPE, BottlingMachineRecipe.class);
    }
}

