/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class MetalPressRecipe
extends MultiblockRecipe {
    public static RecipeType<MetalPressRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<MetalPressRecipe>> SERIALIZER;
    public static final CachedRecipeList<MetalPressRecipe> STANDARD_RECIPES;
    private static final List<MetalPressRecipe> SPECIAL_RECIPES;
    public IngredientWithSize input;
    public final Item mold;
    public final Lazy<ItemStack> output;
    private static ArrayListMultimap<Item, MetalPressRecipe> recipesByMold;
    private static int reloadCountForByMold;

    public static synchronized void addSpecialRecipe(MetalPressRecipe recipe) {
        SPECIAL_RECIPES.add(recipe);
    }

    public MetalPressRecipe(ResourceLocation id, Lazy<ItemStack> output, IngredientWithSize input, Item mold, int energy) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.mold = mold;
        this.setTimeAndEnergy(60, energy);
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)this.output.get()}));
    }

    protected IERecipeSerializer<MetalPressRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public MetalPressRecipe setInputSize(int size) {
        this.input = new IngredientWithSize(this.input.getBaseIngredient(), size);
        return this;
    }

    public boolean matches(ItemStack mold, ItemStack input, Level world) {
        return this.input.test(input);
    }

    public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input, Level world) {
        return this;
    }

    public static MetalPressRecipe findRecipe(ItemStack mold, ItemStack input, Level world) {
        if (mold.m_41619_() || input.m_41619_()) {
            return null;
        }
        List list = MetalPressRecipe.getRecipesByMold(world).get((Object)mold.m_41720_());
        for (MetalPressRecipe recipe : list) {
            if (!recipe.matches(mold, input, world)) continue;
            return recipe.getActualRecipe(mold, input, world);
        }
        return null;
    }

    public static boolean isValidMold(Level level, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        return MetalPressRecipe.getRecipesByMold(level).containsKey((Object)itemStack.m_41720_());
    }

    private static ArrayListMultimap<Item, MetalPressRecipe> getRecipesByMold(Level level) {
        if (reloadCountForByMold != CachedRecipeList.getReloadCount()) {
            recipesByMold = ArrayListMultimap.create();
            Consumer<MetalPressRecipe> addToMap = recipe -> recipesByMold.put((Object)recipe.mold, recipe);
            STANDARD_RECIPES.getRecipes(level).forEach(addToMap);
            SPECIAL_RECIPES.forEach(addToMap);
            reloadCountForByMold = CachedRecipeList.getReloadCount();
        }
        return recipesByMold;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        STANDARD_RECIPES = new CachedRecipeList<MetalPressRecipe>(() -> TYPE, MetalPressRecipe.class);
        SPECIAL_RECIPES = new ArrayList<MetalPressRecipe>();
        recipesByMold = ArrayListMultimap.create();
        reloadCountForByMold = -1;
    }
}

