/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class SqueezerRecipe
extends MultiblockRecipe {
    public static RecipeType<SqueezerRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<SqueezerRecipe>> SERIALIZER;
    public static final CachedRecipeList<SqueezerRecipe> RECIPES;
    public IngredientWithSize input;
    public final FluidStack fluidOutput;
    @Nonnull
    public final Lazy<ItemStack> itemOutput;

    public SqueezerRecipe(ResourceLocation id, FluidStack fluidOutput, @Nonnull Lazy<ItemStack> itemOutput, IngredientWithSize input, int energy) {
        super(itemOutput, TYPE, id);
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.input = input;
        this.setTimeAndEnergy(80, energy);
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)this.itemOutput.get()}));
    }

    protected IERecipeSerializer<SqueezerRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public SqueezerRecipe setInputSize(int size) {
        this.input = this.input.withSize(size);
        return this;
    }

    public static SqueezerRecipe findRecipe(Level level, ItemStack input) {
        if (input.m_41619_()) {
            return null;
        }
        for (SqueezerRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    public static SortedMap<Component, Integer> getFluidValuesSorted(Level level, Fluid f, boolean inverse) {
        TreeMap<Component, Integer> map = new TreeMap<Component, Integer>(Comparator.comparing(Component::getString, inverse ? Comparator.reverseOrder() : Comparator.naturalOrder()));
        for (SqueezerRecipe recipe : RECIPES.getRecipes(level)) {
            if (recipe.fluidOutput == null || recipe.fluidOutput.getFluid() != f || recipe.input.hasNoMatchingItems()) continue;
            ItemStack is = recipe.input.getMatchingStacks()[0];
            map.put(is.m_41786_(), recipe.fluidOutput.getAmount());
        }
        return map;
    }

    static {
        RECIPES = new CachedRecipeList<SqueezerRecipe>(() -> TYPE, SqueezerRecipe.class);
    }
}

