/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.Polygon;
import malte0811.modelsplitter.model.UVCoords;
import malte0811.modelsplitter.model.Vertex;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class PolygonUtils {
    private static int getOffset(VertexFormatElement element) {
        int offset = 0;
        for (VertexFormatElement e : DefaultVertexFormat.f_85811_.m_86023_()) {
            if (e == element) {
                return offset / 4;
            }
            offset += e.m_86050_();
        }
        throw new IllegalStateException("Did not find element with usage " + element.m_86048_().name() + " and type " + element.m_86041_().name());
    }

    public static Polygon<ExtraQuadData> toPolygon(BakedQuad quad) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(4);
        int posOffset = PolygonUtils.getOffset(DefaultVertexFormat.f_85804_);
        int uvOffset = PolygonUtils.getOffset(DefaultVertexFormat.f_166849_);
        int normalOffset = PolygonUtils.getOffset(DefaultVertexFormat.f_85809_);
        int colorOffset = PolygonUtils.getOffset(DefaultVertexFormat.f_85805_);
        int color = quad.m_111303_()[colorOffset];
        for (int v = 0; v < 4; ++v) {
            int baseOffset = v * DefaultVertexFormat.f_85811_.m_86020_() / 4;
            int packedNormal = quad.m_111303_()[normalOffset + baseOffset];
            Vec3d normalVec = new Vec3d((byte)packedNormal, (byte)(packedNormal >> 8), (byte)(packedNormal >> 16)).normalize();
            UVCoords uv = new UVCoords(Float.intBitsToFloat(quad.m_111303_()[uvOffset + baseOffset]), Float.intBitsToFloat(quad.m_111303_()[uvOffset + baseOffset + 1]));
            Vec3d pos = new Vec3d(Float.intBitsToFloat(quad.m_111303_()[baseOffset + posOffset]), Float.intBitsToFloat(quad.m_111303_()[baseOffset + posOffset + 1]), Float.intBitsToFloat(quad.m_111303_()[baseOffset + posOffset + 2]));
            vertices.add(new Vertex(pos, normalVec, uv));
            Preconditions.checkState((quad.m_111303_()[baseOffset + colorOffset] == color ? 1 : 0) != 0, (Object)"All vertices in a quad must have the same color, otherwise we need changes in BMS");
        }
        return new Polygon<ExtraQuadData>(vertices, new ExtraQuadData(quad.m_173410_(), new Vector4f((float)(color & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 24) / 255.0f)));
    }

    public static BakedQuad toBakedQuad(Polygon<ExtraQuadData> poly, ModelState transform) {
        return PolygonUtils.toBakedQuad(poly.getPoints(), poly.getTexture(), transform.m_6189_().blockCenterToCorner(), true);
    }

    public static BakedQuad toBakedQuad(List<Vertex> points, ExtraQuadData data, Transformation rotation, boolean absoluteUV) {
        Preconditions.checkArgument((points.size() == 4 ? 1 : 0) != 0);
        BakedQuadBuilder quadBuilder = new BakedQuadBuilder(data.sprite());
        Vector3f normal = new Vector3f();
        for (Vertex v : points) {
            int i;
            ImmutableList elements = DefaultVertexFormat.f_85811_.m_86023_();
            Vector4f pos = new Vector4f();
            pos.set(PolygonUtils.toArray(v.position(), 4));
            normal.set(PolygonUtils.toArray(v.normal(), 3));
            rotation.transformPosition(pos);
            rotation.transformNormal(normal);
            pos.m_123621_();
            double epsilon = 1.0E-5;
            for (i = 0; i < 2; ++i) {
                if ((double)Math.abs((float)i - pos.m_123601_()) < 1.0E-5) {
                    pos.setX((float)i);
                }
                if ((double)Math.abs((float)i - pos.m_123615_()) < 1.0E-5) {
                    pos.setY((float)i);
                }
                if (!((double)Math.abs((float)i - pos.m_123616_()) < 1.0E-5)) continue;
                pos.setZ((float)i);
            }
            int elementsSize = elements.size();
            block9: for (i = 0; i < elementsSize; ++i) {
                VertexFormatElement element = (VertexFormatElement)elements.get(i);
                switch (element.m_86048_()) {
                    case POSITION: {
                        quadBuilder.put(i, new float[]{pos.m_123601_(), pos.m_123615_(), pos.m_123616_()});
                        continue block9;
                    }
                    case NORMAL: {
                        quadBuilder.put(i, new float[]{normal.m_122239_(), normal.m_122260_(), normal.m_122269_()});
                        continue block9;
                    }
                    case COLOR: {
                        quadBuilder.put(i, new float[]{data.color().m_123601_(), data.color().m_123615_(), data.color().m_123616_(), data.color().m_123617_()});
                        continue block9;
                    }
                    case UV: {
                        if (element.m_86041_() == VertexFormatElement.Type.FLOAT) {
                            if (absoluteUV) {
                                quadBuilder.put(i, new float[]{(float)v.uv().u(), (float)v.uv().v()});
                                continue block9;
                            }
                            quadBuilder.put(i, new float[]{data.sprite().m_118367_(16.0 * v.uv().u()), data.sprite().m_118393_(16.0 * (1.0 - v.uv().v()))});
                            continue block9;
                        }
                        quadBuilder.put(i, new float[]{0.0f, 0.0f});
                        continue block9;
                    }
                    case PADDING: {
                        quadBuilder.put(i, new float[]{0.0f});
                    }
                }
            }
        }
        quadBuilder.setQuadOrientation(Direction.m_122372_((float)normal.m_122239_(), (float)normal.m_122260_(), (float)normal.m_122269_()));
        return quadBuilder.build();
    }

    private static float[] toArray(Vec3d vec, int length) {
        int i;
        float[] ret = new float[length];
        for (i = 0; i < 3; ++i) {
            ret[i] = (float)vec.get(i);
        }
        for (i = 3; i < length; ++i) {
            ret[i] = 1.0f;
        }
        return ret;
    }

    public record ExtraQuadData(TextureAtlasSprite sprite, Vector4f color) {
    }
}

