/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class TurretBlockEntity<T extends TurretBlockEntity<T>>
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IIEInventory,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IInteractionObjectIE<T>,
IEBlockInterfaces.IEntityProof,
IEBlockInterfaces.IScrewdriverInteraction,
IModelOffsetProvider {
    public MutableEnergyStorage energyStorage;
    public boolean redstoneControlInverted;
    public String owner;
    public List<String> targetList;
    public boolean whitelist;
    public boolean attackAnimals;
    public boolean attackPlayers;
    public boolean attackNeutrals;
    protected int tick;
    protected LivingEntity target;
    public float rotationYaw;
    public float rotationPitch;
    private UUID targetId;
    AABB renderBB;
    private final MultiblockCapability<IEnergyStorage> energyCap;

    /*
     * Exception decompiling
     */
    public TurretBlockEntity(BlockEntityType<T> type, BlockPos pos, BlockState state) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void tickClient() {
        this.tickCommon();
    }

    public void tickCommon() {
        double range = this.getRange();
        if (this.targetId != null) {
            AABB validBox = Shapes.m_83144_().m_83215_().m_82338_(this.f_58858_).m_82400_(range);
            List entities = this.f_58857_.m_45976_(LivingEntity.class, validBox);
            for (LivingEntity entity : entities) {
                if (!entity.m_142081_().equals(this.targetId) || !this.isValidTarget(entity, true)) continue;
                this.target = entity;
                break;
            }
            this.targetId = null;
        }
        if (this.target != null) {
            Vec3 delta = this.getGunToTargetVec(this.target);
            double dSq = delta.m_82556_();
            if (dSq > range * range) {
                this.target = null;
            } else if (this.f_58857_.f_46443_) {
                double yaw = Mth.m_14136_((double)delta.f_82479_, (double)delta.f_82481_) * 57.29577951308232 - 180.0;
                this.rotationPitch = (float)(Math.atan2(Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_), delta.f_82480_) * 57.29577951308232) - 90.0f;
                float defaultYaw = 180.0f - this.getFacing().m_122435_();
                this.rotationYaw = this.rotationYaw == 0.0f ? (float)(yaw * 0.5) - defaultYaw : (float)yaw - defaultYaw;
            }
        } else if (this.f_58857_.f_46443_) {
            this.rotationYaw = (float)((double)this.rotationYaw * 0.75);
            if (Math.abs(this.rotationYaw) < 10.0f) {
                this.rotationYaw = 0.0f;
            }
            this.rotationPitch = (float)((double)this.rotationPitch * 0.75);
            if (Math.abs(this.rotationPitch) < 10.0f) {
                this.rotationPitch = 0.0f;
            }
        }
    }

    @Override
    public void tickServer() {
        this.tickCommon();
        if (this.f_58857_.m_46467_() % 64L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0x3F)) {
            this.markContainingBlockForUpdate(null);
        }
        int energy = (Integer)IEServerConfig.MACHINES.turret_consumption.get();
        if (this.isRSPowered() ^ this.redstoneControlInverted) {
            if (this.energyStorage.extractEnergy(energy, true) == energy) {
                this.energyStorage.extractEnergy(energy, false);
                if (this.target == null || !this.target.m_6084_() || this.f_58857_.m_6815_(this.target.m_142049_()) == null || this.target.m_21223_() <= 0.0f || !this.canShootEntity(this.target)) {
                    this.target = this.getTarget();
                    if (this.target != null) {
                        this.m_6596_();
                        this.markContainingBlockForUpdate(null);
                    }
                }
                if (this.target != null && this.canActivate()) {
                    ++this.tick;
                    int chargeup = this.getChargeupTicks();
                    if (this.tick == chargeup) {
                        this.activate();
                    } else if (this.tick > chargeup) {
                        if (this.loopActivation()) {
                            this.activate();
                        } else if (this.tick == chargeup + this.getActiveTicks()) {
                            this.tick = 0;
                        }
                    }
                } else {
                    this.tick = 0;
                }
            }
        } else if (this.target != null) {
            this.target = null;
        }
    }

    private boolean canShootEntity(LivingEntity entity) {
        Vec3 end;
        Vec3 start = this.getGunPosition();
        if (Utils.rayTraceForFirst(start, end = this.getTargetVector(entity), this.f_58857_, Collections.singleton(this.m_58899_().m_7494_())) != null) {
            return false;
        }
        AABB potentialCollateralArea = entity.m_142469_().m_82367_(new AABB(this.f_58858_.m_7494_()));
        List potentialCollateral = this.f_58857_.m_45976_(LivingEntity.class, potentialCollateralArea);
        for (LivingEntity coll : potentialCollateral) {
            AABB entityBB = coll.m_142469_().m_82400_(0.4625);
            if (this.isValidTarget(coll, false) || !entityBB.m_82371_(start, end).isPresent()) continue;
            return false;
        }
        return true;
    }

    protected Vec3 getTargetVector(LivingEntity e) {
        return new Vec3(e.m_20185_(), e.m_20186_() + 0.5 * (double)e.m_20192_(), e.m_20189_());
    }

    protected Vec3 getGunPosition() {
        return new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.375, (double)this.f_58858_.m_123343_() + 0.5);
    }

    protected Vec3 getGunToTargetVec(LivingEntity target) {
        return this.getGunPosition().m_82505_(this.getTargetVector(target));
    }

    @Nullable
    private LivingEntity getTarget() {
        double range = this.getRange();
        List list = this.f_58857_.m_45976_(LivingEntity.class, new AABB((double)this.m_58899_().m_123341_() - range, (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() - range, (double)this.m_58899_().m_123341_() + range, (double)(this.m_58899_().m_123342_() + 3), (double)this.m_58899_().m_123343_() + range));
        if (list.isEmpty()) {
            return null;
        }
        for (LivingEntity entity : list) {
            if (!this.isValidTarget(entity, true)) continue;
            return entity;
        }
        return null;
    }

    public boolean isValidTarget(LivingEntity entity, boolean checkCanShoot) {
        LivingEntity entityOwner;
        if (entity == null || !entity.m_6084_() || entity.m_21223_() <= 0.0f) {
            return false;
        }
        if (this.whitelist ^ this.isListedName(this.targetList, entity.m_7755_().getString())) {
            return false;
        }
        if (entity instanceof TamableAnimal && (entityOwner = ((TamableAnimal)entity).m_142480_()) != null && this.whitelist ^ this.isListedName(this.targetList, entityOwner.m_7755_().getString())) {
            return false;
        }
        if (entity instanceof Animal && !this.attackAnimals) {
            return false;
        }
        if (entity instanceof Player && !this.attackPlayers) {
            return false;
        }
        if (!(entity instanceof Player || entity instanceof Animal || entity instanceof Enemy || this.attackNeutrals)) {
            return false;
        }
        if (this.target == null || this.m_58899_().m_203193_((Position)entity.m_20182_()) < this.m_58899_().m_203193_((Position)this.target.m_20182_())) {
            return true;
        }
        return !checkCanShoot || this.canShootEntity(entity);
    }

    private boolean isListedName(List<String> list, String name) {
        for (String s : list) {
            if (!name.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    protected abstract double getRange();

    protected abstract boolean canActivate();

    protected abstract int getChargeupTicks();

    protected abstract int getActiveTicks();

    protected abstract boolean loopActivation();

    protected abstract void activate();

    protected boolean hasOwnerRights(Player player) {
        if (player.m_150110_().f_35937_ || this.owner == null || this.owner.isEmpty()) {
            return true;
        }
        return this.owner.equalsIgnoreCase(player.m_7755_().getString());
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.m_128425_("add", 8)) {
            this.targetList.add(message.m_128461_("add"));
        }
        if (message.m_128425_("remove", 3)) {
            this.targetList.remove(message.m_128451_("remove"));
        }
        if (message.m_128425_("whitelist", 1)) {
            this.whitelist = message.m_128471_("whitelist");
        }
        if (message.m_128425_("attackAnimals", 1)) {
            this.attackAnimals = message.m_128471_("attackAnimals");
        }
        if (message.m_128425_("attackPlayers", 1)) {
            this.attackPlayers = message.m_128471_("attackPlayers");
        }
        if (message.m_128425_("attackNeutrals", 1)) {
            this.attackNeutrals = message.m_128471_("attackNeutrals");
        }
        this.target = null;
        this.m_6596_();
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.redstoneControlInverted = nbt.m_128471_("redstoneInverted");
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        if (nbt.m_128425_("owner", 8)) {
            this.owner = nbt.m_128461_("owner");
        }
        ListTag list = nbt.m_128437_("targetList", 8);
        this.targetList.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.targetList.add(list.m_128778_(i));
        }
        this.whitelist = nbt.m_128471_("whitelist");
        this.attackAnimals = nbt.m_128471_("attackAnimals");
        this.attackPlayers = nbt.m_128471_("attackPlayers");
        this.attackNeutrals = nbt.m_128471_("attackNeutrals");
        this.target = null;
        if (nbt.m_128425_("target", 8)) {
            this.targetId = UUID.fromString(nbt.m_128461_("target"));
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128379_("redstoneInverted", this.redstoneControlInverted);
        EnergyHelper.serializeTo(this.energyStorage, nbt);
        if (this.owner != null) {
            nbt.m_128359_("owner", this.owner);
        }
        ListTag list = new ListTag();
        for (String s : this.targetList) {
            list.add((Object)StringTag.m_129297_((String)s));
        }
        nbt.m_128365_("targetList", (Tag)list);
        nbt.m_128379_("whitelist", this.whitelist);
        nbt.m_128379_("attackAnimals", this.attackAnimals);
        nbt.m_128379_("attackPlayers", this.attackPlayers);
        nbt.m_128379_("attackNeutrals", this.attackNeutrals);
        if (this.target != null) {
            nbt.m_128359_("target", this.target.m_142081_().toString());
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (!this.isDummy()) {
            return Shapes.m_83144_();
        }
        switch (this.getFacing()) {
            case NORTH: {
                return Shapes.m_83048_((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.875, (double)1.0);
            }
            case SOUTH: {
                return Shapes.m_83048_((double)0.125, (double)0.0625, (double)0.0, (double)0.875, (double)0.875, (double)0.875);
            }
            case WEST: {
                return Shapes.m_83048_((double)0.125, (double)0.0625, (double)0.125, (double)1.0, (double)0.875, (double)0.875);
            }
            case EAST: {
                return Shapes.m_83048_((double)0.0, (double)0.0625, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
            }
        }
        return Shapes.m_83144_();
    }

    public AABB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AABB(this.m_58899_().m_142082_(-8, -8, -8), this.m_58899_().m_142082_(8, 8, 8));
        }
        return this.renderBB;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.isDummy()) {
            BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
            if (te instanceof TurretBlockEntity) {
                return ((TurretBlockEntity)te).screwdriverUseSide(side, player, hand, hitVec);
            }
            return InteractionResult.FAIL;
        }
        if (player.m_6144_() && !this.f_58857_.f_46443_) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            ChatUtils.sendServerNoSpamMessages(player, new Component[]{new TranslatableComponent("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))});
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return NonNullList.m_122779_();
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
    }

    @Override
    public boolean canUseGui(Player player) {
        if (this.hasOwnerRights(player)) {
            return true;
        }
        ChatUtils.sendServerNoSpamMessages(player, new Component[]{new TranslatableComponent("chat.immersiveengineering.info.notOwner", new Object[]{this.owner})});
        return false;
    }

    @Override
    public T getGuiMaster() {
        if (!this.isDummy()) {
            return (T)this;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        if (te instanceof TurretBlockEntity) {
            return (T)((TurretBlockEntity)te);
        }
        return null;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        BlockEntity te;
        if (this.isDummy() && (te = this.f_58857_.m_7702_(this.m_58899_().m_7495_())) instanceof TurretBlockEntity) {
            return ((TurretBlockEntity)te).canEntityDestroy(entity);
        }
        if (entity instanceof Player) {
            return this.hasOwnerRights((Player)entity);
        }
        return true;
    }

    @Override
    public boolean isDummy() {
        return (Boolean)this.m_58900_().m_61143_((Property)IEProperties.MULTIBLOCKSLAVE);
    }

    @Override
    @Nullable
    public TurretBlockEntity<T> master() {
        if (!this.isDummy()) {
            return this;
        }
        IEBlockInterfaces.IGeneralMultiblock iGeneralMultiblock = this.tempMasterBE;
        if (iGeneralMultiblock instanceof TurretBlockEntity) {
            TurretBlockEntity turret = (TurretBlockEntity)iGeneralMultiblock;
            return turret;
        }
        BlockPos masterPos = this.m_58899_().m_7495_();
        BlockEntity te = Utils.getExistingTileEntity(this.f_58857_, masterPos);
        return this.getClass().isInstance(te) ? (TurretBlockEntity)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        this.f_58857_.m_46597_(this.f_58858_.m_7494_(), (BlockState)this.m_58900_().m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        BlockPos otherPos;
        this.tempMasterBE = this.master();
        BlockPos blockPos = otherPos = this.isDummy() ? this.m_58899_().m_7495_() : this.m_58899_().m_7494_();
        if (this.f_58857_.m_7702_(otherPos) instanceof TurretBlockEntity) {
            this.f_58857_.m_7471_(otherPos, false);
        }
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        Entity player = (Entity)context.m_78953_(LootContextParams.f_81455_);
        ItemStack stack = new ItemStack((ItemLike)state.m_60734_(), 1);
        TurretBlockEntity turret = this;
        if (this.isDummy()) {
            BlockEntity t = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
            if (t instanceof TurretBlockEntity) {
                turret = (TurretBlockEntity)t;
            } else {
                return ImmutableList.of((Object)stack);
            }
        }
        CompoundTag tag = new CompoundTag();
        if (!(turret.owner == null || player != null && player.m_7755_().getString().equalsIgnoreCase(turret.owner))) {
            tag.m_128359_("owner", turret.owner);
        }
        if (turret.targetList.size() != 1 || !this.isListedName(turret.targetList, turret.owner)) {
            ListTag list = new ListTag();
            for (String s : turret.targetList) {
                list.add((Object)StringTag.m_129297_((String)s));
            }
            tag.m_128365_("targetList", (Tag)list);
        }
        if (turret.whitelist) {
            tag.m_128379_("whitelist", turret.whitelist);
        }
        if (turret.attackAnimals) {
            tag.m_128379_("attackAnimals", turret.attackAnimals);
        }
        if (!turret.attackPlayers) {
            tag.m_128379_("attackPlayers", turret.attackPlayers);
        }
        if (turret.attackNeutrals) {
            tag.m_128379_("attackNeutrals", turret.attackNeutrals);
        }
        if (turret.redstoneControlInverted) {
            tag.m_128379_("redstoneControlInverted", turret.redstoneControlInverted);
        }
        if (!tag.m_128456_()) {
            stack.m_41751_(tag);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(@Nullable LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128425_("owner", 8)) {
                this.owner = tag.m_128461_("owner");
            } else if (placer != null) {
                this.owner = placer.m_7755_().getString();
            }
            if (tag.m_128425_("targetList", 9)) {
                ListTag list = tag.m_128437_("targetList", 8);
                this.targetList.clear();
                for (int i = 0; i < list.size(); ++i) {
                    this.targetList.add(list.m_128778_(i));
                }
            } else if (this.owner != null) {
                this.targetList.add(this.owner);
            }
            if (tag.m_128425_("whitelist", 1)) {
                this.whitelist = tag.m_128471_("whitelist");
            }
            if (tag.m_128425_("attackAnimals", 1)) {
                this.attackAnimals = tag.m_128471_("attackAnimals");
            }
            if (tag.m_128425_("attackPlayers", 1)) {
                this.attackPlayers = tag.m_128471_("attackPlayers");
            }
            if (tag.m_128425_("attackNeutrals", 1)) {
                this.attackNeutrals = tag.m_128471_("attackNeutrals");
            }
            if (tag.m_128425_("redstoneControlInverted", 1)) {
                this.redstoneControlInverted = tag.m_128471_("redstoneControlInverted");
            }
        } else if (placer != null) {
            this.owner = placer.m_7755_().getString();
            this.targetList.add(this.owner);
        }
    }

    @Nonnull
    public <T2> LazyOptional<T2> getCapability(@Nonnull Capability<T2> cap, @Nullable Direction side) {
        if (!(cap != CapabilityEnergy.ENERGY || side == null && this.isDummy())) {
            return this.energyCap.getAndCast();
        }
        return super.getCapability(cap, side);
    }

    public void setDummy(boolean dummy) {
        BlockState old = this.m_58900_();
        BlockState newState = (BlockState)old.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(dummy));
        this.f_58857_.m_46597_(this.f_58858_, newState);
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        if (this.isDummy()) {
            return new BlockPos(0, 1, 0);
        }
        return BlockPos.f_121853_;
    }
}

