/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.NonNullSupplier;

public class WatermillBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks {
    public int[] offset = new int[]{0, 0};
    public float rotation = 0.0f;
    private Vec3 rotationVec = null;
    public boolean multiblock = false;
    private boolean beingBroken = false;
    public double perTick;
    private final CapabilityReference<IRotationAcceptor> outputCap = CapabilityReference.forNeighbor((BlockEntity)this, IRotationAcceptor.CAPABILITY, (NonNullSupplier<Direction>)((NonNullSupplier)() -> this.getFacing().m_122424_()));
    private final CapabilityReference<IRotationAcceptor> reverseOutputCap = CapabilityReference.forNeighbor((BlockEntity)this, IRotationAcceptor.CAPABILITY, (NonNullSupplier<Direction>)((NonNullSupplier)this::getFacing));
    private AABB renderAABB;

    public WatermillBlockEntity(BlockEntityType<WatermillBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tickClient() {
        this.rotation = (float)((double)this.rotation + this.perTick);
        this.rotation %= 1.0f;
    }

    @Override
    public void tickServer() {
        if (this.isBlocked()) {
            this.setPerTickAndAdvance(0.0);
            return;
        }
        if (this.f_58857_.m_46467_() % 64L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0x3F)) {
            this.rotationVec = null;
        }
        if (this.multiblock) {
            this.multiblock = false;
            return;
        }
        IRotationAcceptor dynamo = this.outputCap.getNullable();
        Direction expandTo = this.getFacing();
        if (dynamo == null) {
            dynamo = this.reverseOutputCap.getNullable();
            expandTo = expandTo.m_122424_();
        }
        if (dynamo != null) {
            BlockEntity blockEntity;
            double power = this.getPower();
            ArrayList<WatermillBlockEntity> connectedWheels = new ArrayList<WatermillBlockEntity>();
            for (int i = 1; i < 3 && this.canUse(blockEntity = SafeChunkUtils.getSafeBE((LevelAccessor)this.f_58857_, this.m_58899_().m_5484_(expandTo, i))); ++i) {
                WatermillBlockEntity asWatermill = (WatermillBlockEntity)blockEntity;
                connectedWheels.add(asWatermill);
                power += asWatermill.getPower();
            }
            this.setPerTickAndAdvance(6.944444612599909E-4 * power / (double)(connectedWheels.size() + 1));
            for (WatermillBlockEntity watermill : connectedWheels) {
                watermill.setPerTickAndAdvance(this.perTick);
                if (watermill.rotation != this.rotation) {
                    watermill.rotation = this.rotation;
                    watermill.markContainingBlockForUpdate(null);
                }
                watermill.multiblock = true;
            }
            dynamo.inputRotation(Math.abs(power * 0.75));
        } else {
            this.setPerTickAndAdvance(6.944444612599909E-4 * this.getPower());
        }
    }

    private void setPerTickAndAdvance(double newValue) {
        if (newValue != this.perTick) {
            this.perTick = newValue;
            this.markContainingBlockForUpdate(null);
        }
        this.rotation = (float)((double)this.rotation + this.perTick);
        this.rotation %= 1.0f;
    }

    private boolean canUse(@Nullable BlockEntity tileEntity) {
        if (!(tileEntity instanceof WatermillBlockEntity)) {
            return false;
        }
        WatermillBlockEntity watermill = (WatermillBlockEntity)tileEntity;
        return watermill.offset[0] == 0 && watermill.offset[1] == 0 && (watermill.getFacing() == this.getFacing() || watermill.getFacing() == this.getFacing().m_122424_()) && !watermill.isBlocked() && !watermill.multiblock;
    }

    public boolean isBlocked() {
        if (this.f_58857_ == null) {
            return true;
        }
        for (Direction fdY : new Direction[]{Direction.UP, Direction.DOWN}) {
            Direction[] directionArray;
            if (this.getFacing().m_122434_() == Direction.Axis.Z) {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.EAST;
                directionArray = directionArray2;
                directionArray2[1] = Direction.WEST;
            } else {
                Direction[] directionArray3 = new Direction[2];
                directionArray3[0] = Direction.SOUTH;
                directionArray = directionArray3;
                directionArray3[1] = Direction.NORTH;
            }
            for (Direction fdW : directionArray) {
                BlockPos pos = this.m_58899_().m_5484_(fdW, 2).m_5484_(fdY, 2);
                BlockState state = this.f_58857_.m_8055_(pos);
                if (Block.m_49918_((VoxelShape)state.m_60808_((BlockGetter)this.f_58857_, pos), (Direction)fdW.m_122424_())) {
                    return true;
                }
                if (!Block.m_49918_((VoxelShape)state.m_60808_((BlockGetter)this.f_58857_, pos), (Direction)fdY.m_122424_())) continue;
                return true;
            }
        }
        return false;
    }

    public double getPower() {
        return this.getFacing().m_122434_() == Direction.Axis.Z ? -this.getRotationVec().f_82479_ : this.getRotationVec().f_82481_;
    }

    public Vec3 getRotationVec() {
        if (this.rotationVec == null) {
            this.rotationVec = new Vec3(0.0, 0.0, 0.0);
            Vec3 dirHoz = this.getHorizontalVec();
            Vec3 dirVer = this.getVerticalVec();
            this.rotationVec = this.rotationVec.m_82549_(dirHoz);
            this.rotationVec = this.rotationVec.m_82549_(dirVer);
        }
        return this.rotationVec;
    }

    private Vec3 getHorizontalVec() {
        Vec3 dir = new Vec3(0.0, 0.0, 0.0);
        boolean faceZ = this.getFacing().ordinal() <= 3;
        dir = dir.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(-(faceZ ? 1 : 0), 3, -(faceZ ? 0 : 1))));
        dir = dir.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(0, 3, 0)));
        dir = dir.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(faceZ ? 1 : 0, 3, faceZ ? 0 : 1)));
        dir = dir.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(-(faceZ ? 2 : 0), 2, -(faceZ ? 0 : 2))));
        dir = dir.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(faceZ ? 2 : 0, 2, faceZ ? 0 : 2)));
        dir = dir.m_82546_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(-(faceZ ? 2 : 0), -2, -(faceZ ? 0 : 2))));
        dir = dir.m_82546_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(faceZ ? 2 : 0, -2, faceZ ? 0 : 2)));
        dir = dir.m_82546_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(-(faceZ ? 1 : 0), -3, -(faceZ ? 0 : 1))));
        dir = dir.m_82546_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(0, -3, 0)));
        dir = dir.m_82546_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(faceZ ? 1 : 0, -3, faceZ ? 0 : 1)));
        return dir;
    }

    private Vec3 getVerticalVec() {
        Vec3 dir = new Vec3(0.0, 0.0, 0.0);
        Vec3 dirNeg = new Vec3(0.0, 0.0, 0.0);
        dirNeg = dirNeg.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(-(this.getFacing().m_122434_() == Direction.Axis.Z ? 2 : 0), 2, -(this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 2))));
        dirNeg = dirNeg.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(-(this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 0), 1, -(this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 3))));
        dirNeg = dirNeg.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(-(this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 0), 0, -(this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 3))));
        dirNeg = dirNeg.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(-(this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 0), -1, -(this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 3))));
        dirNeg = dirNeg.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(-(this.getFacing().m_122434_() == Direction.Axis.Z ? 2 : 0), -2, -(this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 2))));
        Vec3 dirPos = new Vec3(0.0, 0.0, 0.0);
        dirPos = dirPos.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? 2 : 0, 2, this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 2)));
        dirPos = dirPos.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 0, 1, this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 3)));
        dirPos = dirPos.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 0, 0, this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 3)));
        dirPos = dirPos.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 0, -1, this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 3)));
        dirPos = dirPos.m_82549_(Utils.getFlowVector(this.f_58857_, this.m_58899_().m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? 2 : 0, -2, this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 2)));
        dir = this.getFacing().m_122434_() == Direction.Axis.Z ? dir.m_82520_(dirNeg.f_82480_ - dirPos.f_82480_, 0.0, 0.0) : dir.m_82520_(0.0, 0.0, dirNeg.f_82480_ - dirPos.f_82480_);
        return dir;
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        this.rotationVec = new Vec3((double)((float)id / 10000.0f), 0.0, (double)((float)arg / 10000.0f));
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.offset = nbt.m_128465_("offset");
        this.rotation = nbt.m_128457_("rotation");
        this.perTick = nbt.m_128459_("perTick");
        if (this.offset == null || this.offset.length < 2) {
            this.offset = new int[]{0, 0};
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128385_("offset", this.offset);
        nbt.m_128350_("rotation", this.rotation);
        nbt.m_128347_("perTick", this.perTick);
    }

    public AABB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offset[0] == 0 && this.offset[1] == 0 ? new AABB((double)(this.m_58899_().m_123341_() - (this.getFacing().m_122434_() == Direction.Axis.Z ? 2 : 0)), (double)(this.m_58899_().m_123342_() - 2), (double)(this.m_58899_().m_123343_() - (this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : 2)), (double)(this.m_58899_().m_123341_() + (this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 1)), (double)(this.m_58899_().m_123342_() + 3), (double)(this.m_58899_().m_123343_() + (this.getFacing().m_122434_() == Direction.Axis.Z ? 1 : 3))) : new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1), (double)(this.m_58899_().m_123343_() + 1));
        }
        return this.renderAABB;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL_PREFER_SIDE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.m_58899_().m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? -this.offset[0] : 0, -this.offset[1], this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : -this.offset[0]);
        BlockEntity te = SafeChunkUtils.getSafeBE((LevelAccessor)this.f_58857_, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        state = (BlockState)state.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2) || hh == 0 && ww == 0) continue;
                BlockPos pos2 = this.f_58858_.m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? ww : 0, hh, this.getFacing().m_122434_() == Direction.Axis.Z ? 0 : ww);
                this.f_58857_.m_46597_(pos2, state);
                WatermillBlockEntity dummy = (WatermillBlockEntity)this.f_58857_.m_7702_(pos2);
                dummy.setFacing(this.getFacing());
                dummy.offset = new int[]{ww, hh};
            }
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        if (this.beingBroken) {
            return;
        }
        BlockPos initPos = pos.m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? -this.offset[0] : 0, -this.offset[1], this.getFacing().m_122434_() == Direction.Axis.X ? -this.offset[0] : 0);
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                BlockPos pos2;
                BlockEntity blockEntity;
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2) || !((blockEntity = this.f_58857_.m_7702_(pos2 = initPos.m_142082_(this.getFacing().m_122434_() == Direction.Axis.Z ? ww : 0, hh, this.getFacing().m_122434_() == Direction.Axis.X ? ww : 0))) instanceof WatermillBlockEntity)) continue;
                WatermillBlockEntity dummy = (WatermillBlockEntity)blockEntity;
                dummy.beingBroken = true;
                this.f_58857_.m_7471_(pos2, false);
            }
        }
    }
}

