/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.IngredientFluidStack;
import blusunrize.immersiveengineering.common.util.IELogger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public abstract class AbstractFluidAwareRecipe<MatchLocation extends IMatchLocation>
implements CraftingRecipe {
    protected static final boolean[] BOOLEANS = new boolean[]{true, false};
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final ResourceLocation id;
    private final String group;

    public AbstractFluidAwareRecipe(ResourceLocation idIn, String groupIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public String m_6076_() {
        return this.group;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.recipeOutput;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        return this.findMatch(inv) != null;
    }

    @Nullable
    protected abstract MatchLocation findMatch(CraftingContainer var1);

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        return this.m_8043_().m_41777_();
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        MatchLocation offset = this.findMatch(inv);
        if (offset == null) {
            IELogger.logger.error("IRecipe#getRemainingItems was called with an inventory that does not match the recipe");
            IELogger.logger.error("according to IRecipe#matches. This is probably a bug in some mod in the following stacktrace,");
            IELogger.logger.error("if in doubt report it to Immersive Engineering", (Throwable)new IllegalArgumentException());
            return super.m_7457_((Container)inv);
        }
        for (int x = 0; x < inv.m_39347_(); ++x) {
            for (int y = 0; y < inv.m_39346_(); ++y) {
                int invIndex = this.getInventoryIndex(inv, x, y);
                int ingrIndex = offset.getListIndex(x, y);
                if (ingrIndex < 0 || ingrIndex >= this.m_7527_().size()) continue;
                Ingredient ingr = (Ingredient)this.m_7527_().get(ingrIndex);
                ItemStack item = inv.m_8020_(invIndex);
                ItemStack result = ItemStack.f_41583_;
                if (ingr instanceof IngredientFluidStack) {
                    result = ((IngredientFluidStack)ingr).getExtractedStack(item.m_41777_());
                } else if (item.hasContainerItem()) {
                    result = item.getContainerItem();
                }
                if (result == item) {
                    result = result.m_41777_();
                }
                remaining.set(invIndex, (Object)result);
            }
        }
        return remaining;
    }

    private int getInventoryIndex(CraftingContainer inv, int x, int y) {
        return x + y * inv.m_39347_();
    }

    public static interface IMatchLocation {
        public int getListIndex(int var1, int var2);
    }
}

